/*  fichier de configuration d'un DMD RGB 128x32 pixels
*   - 256 Couleurs mode RGB332 et Monochrome -
*   decembre 2017 par Christophe Girardot Aka Aganyte
*/

// définition des entrées/sorties
DigitalOut A(D0);
DigitalOut B(D1);
DigitalOut C(D2);
DigitalOut D(D3);
DigitalOut CLK(D4);
DigitalOut LATCH(D5);
DigitalOut EN(D6);
DigitalOut R1(D7);
DigitalOut G1(A5);
DigitalOut B1(A4);
DigitalOut R2(A3);
DigitalOut G2(A2);
DigitalOut B2(A1);
DigitalIn mybutton(USER_BUTTON); // Déclaration du bouton présent sur la carte nucleo
AnalogIn adc_temp(ADC_TEMP); // Configuration du capteur de temperature
AnalogIn adc_vbat(ADC_VBAT); // Configuration de la lecture de tension de batterie

// Paramètres de réglages des couleurs 
// -----------------------------------
// (ne modifier ces valeurs qu'avec une mire présantant les 8 nuances de couleurs en RVB et Blanc)
// seulement 7 valeurs car la 8eme nuances corréspond aux leds éteintes
#define Start_Time_Shade0   0
#define Start_Time_Shade1   10
#define Start_Time_Shade2   10
#define Start_Time_Shade3   50
#define Start_Time_Shade4   100
#define Start_Time_Shade5   200
#define Start_Time_Shade6   300

/* Permet aussi de gagner du temps... */
unsigned int Time_Shade[7] = 
{
    Start_Time_Shade0,Start_Time_Shade1,Start_Time_Shade2,
    Start_Time_Shade3,Start_Time_Shade4,Start_Time_Shade5,
    Start_Time_Shade6
};

/* Tableaux qui définissent la puissance de chaque niveau de brightness */
unsigned char Adjust_Brightness_shade1[10] = { 9,8,7,6,5,4,3,2,1,0 };
unsigned char Adjust_Brightness_shade2[10] = { 9,8,7,6,5,4,3,2,1,0 };
unsigned char Adjust_Brightness_shade3[10] = { 18,16,14,12,10,8,6,4,2,0 };
unsigned char Adjust_Brightness_shade4[10] = { 36,32,28,24,20,16,12,8,4,0 };
unsigned char Adjust_Brightness_shade5[10] = { 72,64,56,48,40,32,24,16,8,0 };
unsigned char Adjust_Brightness_shade6[10] = { 144,128,96,50,80,64,48,32,16,0 };