#include "mbed.h"
#include "HIDScope.h"

// Motor 1 has PWM-pin D6 and direction-pin D7

AnalogIn pot1(A0);
DigitalOut directionpin(D7);
PwmOut pwmpin(D6);
HIDScope scope(1); // We’re going to send 1 channel of data
Ticker AInTicker;

void ReadAnalogInAndFilter(){
        float a = 2.0f*pot1-1.0f; //value of the potmeter is rescaled between -1 and 1
        scope.set(0, a);  // save scaled potmeter value
        scope.send(); // send what's in scope memory to PC
}

void SetMotorSpeed(){
        float u = 2.0f*pot1-1.0f; 
        directionpin = u > 0.0f; //either true or false, output 0 or 1
        pwmpin = fabs(u); //pwm duty cycle can only be positive, floating point absolute value of the potmeter value
}

int main(){
    pwmpin.period_us(60);
    while(true){
    AInTicker.attach(&ReadAnalogInAndFilter, 0.01f);
    SetMotorSpeed();
    }
}