#include "mbed.h"
#include "HIDScope.h"
#include "BiQuad.h"
 
// Define the HIDScope and Ticker object
HIDScope    scope(3);
Ticker      scopeTimer;

BiQuadChain bqc;
BiQuad      bqlp(0.2928920553392428, 0.5857841106784856, 0.2928920553392428, -1.3007020142696517e-16,0.17156822135697122);
BiQuad      bqhp(0.9599250424722232, -1.9198500849444464, 0.9599250424722232, -1.9179540214230233, 0.9217461484658696); 
BiQuad      bqn50(0.9340059945350248, -1.84501366169642, 0.9340059945350248, -1.84501366169642, 0.8680119890700493);
BiQuad      bqn100(0.8469468086519927, -1.6109885626477245, 0.8469468086519927, -1.6109885626477245, 0.6938936173039855);
BiQuad      bqn150(0.7902067962894531, -1.4081588219037828, 0.7902067962894531, -1.4081588219037828, 0.5804135925789063);
BiQuad      bqn200(0.7902104553475195, -1.278587375017818, 0.7902104553475195, -1.278587375017818, 0.5804209106950391);
BiQuad      bqn250(0.7074573673408703, -1.0004958036942233, 0.7074573673408703, -1.0004958036942233, 0.4149147346817406);

// Read the analog input
AnalogIn    emg1(A0);
AnalogIn    emg2(A1);

double emgSample() 
{
    double emgFiltered = bqc.step(emg1.read());
    return emgFiltered;
}

// The data read and send function
void scopeSend()
{
    scope.set(0,emg1.read());
    scope.set(1,emg2.read());
    scope.set(2,emgSample());
    scope.send();
}
 
int main()
{
    // Attach the data read and send function at 100 Hz
    bqc.add( &bqlp ).add( &bqhp ).add(&bqn50).add(&bqn100).add(&bqn150).add(&bqn200).add(&bqn250);
    scopeTimer.attach_us(&scopeSend, 2e3);   
    
    while(1) { }
}