/** \file main.cpp
 *  \brief mbed UTFT demo for 3.2 TFT LCD Touch Shield module with SSD1289 and XPT2046 touchscreen.
 *  \example shield http://wiki.iteadstudio.com/3.2_TFT_LCD_Touch_Shield
 ***************************************************************************************/

#include "mbed.h"
#include "ssd1289.h"
#include "UTouch.h"



BusOut lcdDataBus(PC_9,PA_9,PB_9,PA_8,PB_10,PB_4,PB_5,PC_7,PA_12,PA_11,PB_12,PB_2,PB_1,PB_15,PB_14,PB_13); // 16 D0-D15

SSD1289_LCD myGLCD(PC_4,PA_10,PC_8,PC_6, &lcdDataBus ); //CS, RESET, RS, WR, DATA_PORT
                            
UTouch  myTouch (  PB_6, PA_7, PA_6, PA_5, PB_8); //T_CLK T_CS T_DIN T_DOUT  T_IRQ


int main() {
  myGLCD.Initialize();
  myGLCD.SetBackground(COLOR_BLACK);
  myGLCD.SetForeground(COLOR_BLACK);
  myGLCD.FillScreen(COLOR_GREEN);
  myGLCD.SetFont(&TerminusFont);
  myTouch.InitTouch();
  myTouch.SetPrecision(PREC_HI);
    
        
while(1==1) {
        int buf[318];
        int x;
        int y; 
        
    
     myGLCD.ClearScreen();
     myGLCD.DrawLine(159, 15, 159, 224);
     myGLCD.DrawLine(1, 119, 318, 119);
  for (int i=9; i<310; i+=10)
    myGLCD.DrawLine(i, 117, i, 121);
  for (int i=19; i<220; i+=10)
    myGLCD.DrawLine(157, i, 161, i);

// Draw sin-, cos- and tan-lines  
  
  myGLCD.Print("Sin", 5, 15, COLOR_RED);
  for (int i=1; i<318; i++)
  {
    myGLCD.DrawPixel(i,119+(sin(((i*1.13)*3.14)/180)*95), COLOR_RED);
  }
    
  myGLCD.Print("Cos", 5, 27, COLOR_YELLOW);
  for (int i=1; i<318; i++)
  {
    myGLCD.DrawPixel(i,119+(cos(((i*1.13)*3.14)/180)*95), COLOR_YELLOW);
  }

 
  myGLCD.Print("Tan", 5, 39);
  for (int i=1; i<318; i++)
  {
    myGLCD.DrawPixel(i,119+(tan(((i*1.13)*3.14)/180)),COLOR_BLUE);
  }
    wait(3);
    myGLCD.ClearScreen();

// Draw a moving sinewave
    x=1;
  for (int i=1; i<(318*20); i++) 
  {
    x++;
    if (x==319)
      x=1;
    if (i>319)
    {
      if ((x==159)||(buf[x-1]==119))
        myGLCD.SetForeground(COLOR_RED);
      else
        
      myGLCD.DrawPixel(x,buf[x-1], COLOR_BLUE);
    }
    
    y=119+(sin(((i*1.1)*3.14)/180)*(90-(i / 100)));
    myGLCD.DrawPixel(x,y);
    buf[x-1]=y;
  }
    
    wait(2);
    myGLCD.ClearScreen();

// Draw some lines in a pattern
      
  for (int i=15; i<224; i+=5)
  {
    myGLCD.DrawLine(1, i, (i*1.44)-10, 224, COLOR_BLUE);
  }
  
  for (int i=224; i>15; i-=5)
  {
    myGLCD.DrawLine(318, i, (i*1.44)-11, 15,COLOR_GREEN);
  }
  
  for (int i=224; i>15; i-=5)
  {
    myGLCD.DrawLine(1, i, 331-(i*1.44), 15, COLOR_RED);
  }
  
  for (int i=15; i<224; i+=5)
  {
    myGLCD.DrawLine(318, i, 330-(i*1.44),224, COLOR_CYAN);
  }
wait(3);
    myGLCD.ClearScreen();
}
}
