#include "MCP23017.h"
#include "WattBob_TextLCD.h"
#define BACK_LIGHT_ON(INTERFACE) INTERFACE->write_bit(1,BL_BIT)
#define BACK_LIGHT_OFF(INTERFACE) INTERFACE->write_bit(0,BL_BIT)
#include <string>
#include "chipNumbers.h"
MCP23017 *par_port;
WattBob_TextLCD *lcd;

/*  void printLCD(const char * text)
 *  Take a character array and split and trim it into two lines, to be displayed on the WattBob LCD screen.
 */
void printLCD(const char * text)
{
    std::string txt_str = std::string(text); //Convert ther character array to a std::string,
    //to use in the string manipulation functions.
    lcd->reset();
    if(txt_str.length() > 32) {
        int length = txt_str.length();
        txt_str = txt_str.erase(32,length-32);
        lcd->locate(0,0);   //Going to new line
        text = txt_str.c_str();
    }
    if(txt_str.length() > 16) {
        string line1 = txt_str.substr(0,16);
        string line2 = txt_str.substr(16,16);
        lcd->locate(0,0);   //Going to new line
        lcd->printf(line1.c_str());
        lcd->locate(1,0);   //Going to new line
        lcd->printf(line2.c_str());
        lcd->locate(0,0);   //Going to new line
    }
    if(txt_str.length() <= 16) {
        lcd->locate(0,0);
        lcd->printf(text);
    }

}

/*  void printLCD(string txt_str)
 *  Take a string and split and trim it into two lines, to be displayed on the WattBob LCD screen.
 */
void printLCD(string txt_str)
{
    lcd->reset();
    if(txt_str.length() > 32) {
        int length = txt_str.length();
        txt_str = txt_str.erase(32,length-32);
        lcd->locate(0,0);   //Going to new line

    }
    if(txt_str.length() > 16) {
        string line1 = txt_str.substr(0,16);
        string line2 = txt_str.substr(16,16);
        lcd->locate(0,0);   //Going to new line
        lcd->printf(line1.c_str());
        lcd->locate(1,0);   //Going to new line
        lcd->printf(line2.c_str());
        lcd->locate(0,0);   //Going to new line
    }
    if(txt_str.length() <= 16) {
        lcd->locate(0,0);
        lcd->printf(&txt_str[0]);
    }

}
/*  void setupLCD()
 *  Setup the I2C communication line to the WattBob.
 */
void setupLCD()
{
    par_port = new MCP23017(p9, p10, 0x40);
    par_port->config(0x0F00, 0x0F00, 0x0F00); // configure MCP23017 chip on WattBob
    BACK_LIGHT_ON(par_port);
    lcd = new WattBob_TextLCD(par_port);
    lcd->reset();
}
/*  void printStoresChipValues()
 *  Print out the values of the stored chip values to the LCD.
 */
void printStoredChipValues()
{
    stringstream strs;
    strs << "Stored chip values";
    strs << "R:";
    strs << redAmount;
    strs << ", G:";
    strs << greenAmount;
    strs << ", B:";
    strs << blueAmount;
    string temp_str = strs.str();
    char const* pchar = temp_str.c_str();
    printLCD(pchar);
}