bool operationMode      = true; //the MBED starts in operation mode.

#include "mbed.h"
Serial pc(USBTX, USBRX);
Serial glcd(p13, p14);
#include "rtos.h"
#include "Language.h"
DigitalIn languageButton(p30);
Language currentLanguage = ENGLISH;
#include <sstream>
#include <string>
#include "mbedStorage.h"
#include "mbedLCD.h"
#include "stateMachine.h"
#include "FPGAcomms.h"
#ifndef serialComm
#define serialComm
#include "serialCommunication.h"
#endif


DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

StateMachine stateMachine;

//Boolean values to easily enable and disable certain features for individual testing
bool colourSensor   =   true;
bool cardReader     =   true;
bool sorter         =   true;
bool dispensor      =   true;
bool testFunctions  =   true;
bool serialComms    =   true;

int mode = 0;   //mode select
int maintenanceModeSelect = 0;

//Call to check if an MBED button is pressed
bool buttonPressed(int buttonNumber)
{
    if(buttonNumber > -1 && buttonNumber < 4) {
        return par_port->read_bit(buttonNumber + 8);
    }
    return false;
}
//Run a mode, defined by 'mode'.
void checkSortDispenseButtons()
{

    if(buttonPressed(3)) {
        mode = !mode;
    }
    /* NOTICE: Enable the modes below for more maintenace functions, good for debugging.
     */


    /*
        if(mode == 0) {                                    //Dispense Mode
            printLCD("Dispense Mode");
            operationMode=false;
            if(buttonPressed(0)) {
                printLCD("Red Button pressed");
                dispense(RED);
            } else if(buttonPressed(1)) {
                printLCD("Green Button pressed");
                dispense(GREEN);
            } else if(buttonPressed(2)) {
                printLCD("Blue Button pressed");
                dispense(BLUE);
            }

        } *//*else if(mode == 1) {                               //Sort Mode
printLCD("Sort Mode");
operationMode=false;
if(buttonPressed(0)) {
log("Red Button pressed");
sort(RED);
} else if(buttonPressed(1)) {
log("Green Button pressed");
sort(GREEN);
} else if(buttonPressed(2)) {
log("Blue Button pressed");
sort(BLUE);
}

}*//* else if(mode == 2) {                               //Bin/Recycle Mode
printLCD("Bin/Recycle Mode");
operationMode=false;
if(buttonPressed(0)) {
log("Bin button pressed");
sort(BIN);
} else if(buttonPressed(1)) {
log("Recycle Button");
recycle();
}
} */
    /*else if(mode == 4) {                               //Card Reader Mode
        operationMode= true;
        if(cardReader && cardDetect) {
            cardAcquisition();

        }*/
    if(mode == 0) {                               //Storage Mode
        operationMode=true;
        stringstream ss;
        ss << "Operation:   " << "R:" << redAmount << "G:" << greenAmount << "B:" << blueAmount << "RE:" << recycleAmount;
        string tmp = ss.str();
        printLCD(tmp.c_str());
        wait(0.1);
        if(buttonPressed(0)) {
            //log("Dispense all button pressed");
            dispenseAll();
        } else if(buttonPressed(1)) {
            //log("Clear stored numbers button pressed");
            writeFile(0,0,0,recycleAmount);
            redAmount = 0;
            greenAmount = 0;
            blueAmount = 0;
            printLCD("Cleared values");

        } else if(buttonPressed(2)) {
            //log("Increment all stored values by 2.");
            redAmount += 2;
            greenAmount += 2;
            blueAmount += 2;
            writeFile(redAmount,greenAmount,blueAmount,recycleAmount);

            printLCD("set values to 2");

        }
    } else if(mode == 1) {
        operationMode = false;
        stringstream ss;
        ss << maintenanceModeSelect;
        string mainModeSelect = ss.str();
        printLCD("Maintenance: " + mainModeSelect);
        wait(0.1);                           //Maintenance Mode
       
        if(buttonPressed(0)) {                     //Next maintenance function
            maintenanceModeSelect++;
            if(maintenanceModeSelect > 13) maintenanceModeSelect = 0;
        } else if(buttonPressed(1)) {               //Previous maintenance function
            maintenanceModeSelect--;
            if(maintenanceModeSelect < 0) maintenanceModeSelect = 13;
        } else if(buttonPressed(2)) {              //Process Instruction
            switch(maintenanceModeSelect) {
                case 0://RB_LEFT:
                    printLCD("Moving Red/Blue Slider left.");
                    maintain(RB_LEFT);
                    break;

                case 1://RB_CENTRE:
                    printLCD("Centering Red/Blue Slider.");
                    maintain(RB_CENTRE);
                    break;

                case 2://RB_RIGHT:
                    printLCD("Moving Red/Blue Slider right.");
                    maintain(RB_RIGHT);
                    break;

                case 3://GO_UP:
                    printLCD("Moving Green Slider up.");
                    maintain(GO_UP);
                    break;

                case 4://GO_CENTRE:
                    printLCD("Centering Green Slider.");
                    maintain(GO_CENTRE);
                    break;

                case 5://GO_DOWN:
                    printLCD("Moving Green Slider down.");
                    maintain(GO_DOWN);
                    break;

                case 6://BR_LEFT:
                    printLCD("Moving Bin Slider left.");
                    maintain(BR_LEFT);
                    break;

                case 7://BR_RIGHT:
                    printLCD("Moving Bin Slider right.");
                    maintain(BR_RIGHT);
                    break;

                case 8://R_PUSH:
                    printLCD("Pushing red dispensor");
                    maintain(R_PUSH);
                    break;

                case 9://R_HOME:
                    printLCD("Homing red dispensor");
                    maintain(R_HOME);
                    break;

                case 10://GB_LEFT:
                    printLCD("Pushing green dispensor");
                    maintain(GB_LEFT);
                    break;

                case 11://GB_CENTRE:
                    printLCD("Centre green/blue dispensor");
                    maintain(GB_CENTRE);
                    break;

                case 12://GB_RIGHT:
                    printLCD("Pushing blue dispensor");
                    maintain(GB_RIGHT );
                    break;

                case 13: //MaintenanceEND
                    printLCD("Ending Maintenance Mode");
                    maintain(maintenanceEND);
                    break;
            }
            printLCD("Ready for next command");
            wait(1);
        }
    }
}
//Coordinate changing language on PC and Arduino.
void changeLanguage()
{
    currentLanguage = nextLanguage(currentLanguage);        //Change the language on teh MBED.
    sendLanguageCharacter();                                //Tell PC & Arduino to change language.
    wait(1);
}

/* void sortFunction()
 *  Read sensor and sort according to the colour.
 */
void sortFunction()
{
    //Read the colour twice and make sure both are the same. If not then return and try again.
    Thread::wait(100);
    Colour colour = readColourSensor();
    Thread::wait(100);
    Colour colour2 = readColourSensor();
    if(colour != colour2) {
        return;
    }
    //Ensure a bin read is valid by ensuring it is the same as earlier. Prevents a bin read being valid if the chip is out of place on the sensor.
    if(colour == BIN) {
        Thread::wait(100);
        Colour binCheck = readColourSensor();
        if(binCheck != colour) {
            return;
        }
    }

    //log("Sorting colour");
    sort(colour);
}

//Run sortFunction with a small delay between iterations, pulses LED.
void sortMode(void const* args)
{
    while(colourSensor && sorter) {
        if(operationMode) {
            led2 = 1;
            sortFunction();
            led2 = 0;
            Thread::wait(50);
        }
    }
}

bool pcReady = false;   //Defines  whether the PC is ready to accept characters on the COM port.
//handles dispensing from a card, changing language
void dispenseFunction()
{
    if(!pcReady) {
        if(pc.getc() == '*') {
            pcReady = true;
        }
    } else {
        //Check language button
        if(languageButton) {
            changeLanguage();
        }
        if(cardReader && cardDetect) {
            //Read card
            int cardNumber = cardAcquisition();

            //Send message to pc
            pc.putc('*');
            wait(0.5);

            //Send card number to pc
            pc.printf("%i\n",cardNumber);

            int red = 0;
            int green = 0;
            int blue = 0;

            //Get order from pc, convert characters to integers.
            red = (int) pc.getc() - '0';
            green = (int) pc.getc() - '0';
            blue = (int) pc.getc() - '0';

            //Check if there are enough chips to dispense order
            Thread::wait(100);
            if(red > redAmount || green > greenAmount || blue > blueAmount) {
                //If not then do not dispense
                pc.putc('<');
                pcReady = false;
            } else if(red ==0 && green == 0 && blue ==0) {
                pc.putc('@');
                pcReady = false;
            } else {
                //Otherwise there are enough tokens so dispense the order
                pc.putc('>');

                //Display order on LCD
                glcd.putc(27);
                glcd.putc(18);
                glcd.putc(red + '0'); //Convert int to char
                glcd.putc(green + '0');//Convert int to char
                glcd.putc(blue + '0');//Convert int to char
                glcd.putc(255);

                //Dispense Order
                dispenseOrder(red,green,blue);

                //Display finished dispensing on lcd
                glcd.putc(27);
                glcd.putc(19);
                glcd.putc(255);

                //Reset pc ready
                pcReady = false;
                wait(1);
                pc.putc('(');
            }

        }
    }
}
//Runs dispenseFunction with a small delay between iterations, pulses LED.
void dispenseMode(void const* args)
{

    while(true) {
        if(operationMode) {
            led3 = 1;
            dispenseFunction();
            led3 =0;
            Thread::wait(50);
        }

    }
}


int main()
{
    led1 = 0;
    setupLCD();
    printLCD("Welcome to the  Chipin Sorter");
    Thread::wait(1000);
    readChipNumbers();
    printStoredChipValues();
    printLCD("Resetting all sliders");
    maintain(maintenanceEND);   //reset sliders on FPGA
    printLCD("");
    Thread::wait(1000);
    sendLanguageCharacter();    //Synchronise language on PC and arduino

    Thread sortThread(sortMode);    //Start the sorting thread.
    if(!languageButton) {   //Decide whether to start in operation mode or maintenance mode.
        operationMode = true;
        mode = 0;

    } else {
        operationMode = false;
        mode = 1;
    }
    Thread dispenseThread(dispenseMode);    //Start the dispensing thread.
    while(true) {
        led1 = 1;   //pulse led1
        led4 = cardDetect;

        if(!operationMode) {    //Check for maintenance commands if in maintenance mode.
            checkSerial();
        }
        if(testFunctions) checkSortDispenseButtons();   //Run the MBED modes if enabled.
        Thread::wait(100);
        led1=0;
        Thread::wait(100);
    }
}
