#include "mbed.h"
/*  Allows easy enable and disable of log file.
 *  WARNING: Every time a file is changed on the MBED, it reconnects to the PC,
 *  resulting in hundrets of Autoplay notices appearing on your desktop window.
 *  Unplug the MBED from the PC for best results.
 *  Logging is extremely useful for debugging but should be disabled when not debugging.
 */
bool logEnable = false; 
LocalFileSystem local("local");

/*  void writeFile(int r, int g, int b, int re)
 *  Write the values of each storage tube to the datafile.
 *  Ensures no negative values are written to the file.
 */
void writeFile(int r, int g, int b, int re)
{
    FILE* file = fopen("/local/df.txt","w"); // open file
    if(r >= 0) {
        fputc(r, file); // put char (data value) into file
    } else {
        fputc(0, file);
    }
    if(g >= 0) {
        fputc(g, file); 
    } else {
        fputc(0, file);
    }
    if(b >= 0) {
        fputc(b, file); 
    } else {
        fputc(0, file);
    }
    if(re >= 0) {
        fputc(re, file); 
    } else {
        fputc(0, file);
    }
    fclose(file); // close file
}
/*  int readFile(int index)
 *  Read a character from the datafile and return as an integer.
 */
int readFile(int index)
{
    FILE* file = fopen ("/local/df.txt","r"); // open file for reading
    int read_var = 0;
    for(int i = 0; i <= index; i++) {
        read_var = fgetc(file); // read data value
    }
    fclose(file); // close file
    return read_var;
}

/*  void log(char* text)
 *  Append a charcater array on a new line in the log file.
 */
void log(char* text)
{
    if(logEnable) {
        FILE* file = fopen ("/local/log.txt", "a");
        fputs(text, file);
        fputs("\r\n", file);
        fclose(file);
    }
}
/*  void clearLog()
 *  Clear the log file.
 */
void clearLog()
{
    FILE* file = fopen ("/local/log.txt", "w");
    fclose(file);
}