#include "cardReader.h"


/*  void sendCharacter(char ch)
 *  Send a character along the serial port to the PC.
 */
void sendCharacter(char ch)
{
    pc.putc(ch);
}

/*  void sendString(char* ch)
 *  Send a string along the serial port to the PC.
 */
void sendString(char* ch)
{
    pc.puts(ch);
}
/*  void processMessage(char c)
 *  Decide what to do when a character is recieved.
 */
void processMessage(char c)
{
    switch(c) {
        case 'a' :  //Dispense red
            dispense(RED);
            sendCharacter('A'); //Tell the PC the operation is complete
            break;

        case 'b' :  //dispense green
            dispense(GREEN);
            sendCharacter('B');//Tell the PC the operation is complete
            break;

        case 'c':   //dispense blue
            dispense(BLUE);
            sendCharacter('C');//Tell the PC the operation is complete
            break;

        case 'm':// Read card command
            sendCharacter('M');
            int cardNumber = cardAcquisition();
            //Send card number to pc
            wait(0.5);
            pc.printf("%i\n",cardNumber);
            printLCD("Reading Card");
            break;

        case 'X':
            sendCharacter('X'); //Notify the PC that this is an MBED
            printLCD("Connected to PC");
            break;

        case 'd':   //Sort Bin
            sort(BIN);
            sendCharacter('D');//Tell the PC the operation is complete
            break;

        case 'o':   //testServoredBlueLeft
            maintain(RB_LEFT);
            sendCharacter('O');//Tell the PC the operation is complete
            break;

        case 'p':
            maintain(RB_CENTRE);
            sendCharacter('P');//Tell the PC the operation is complete
            break;

        case 'q':
            maintain(RB_RIGHT);
            sendCharacter('O');//Tell the PC the operation is complete
            break;


        case 's':
            maintain(GO_UP);
            sendCharacter('S');//Tell the PC the operation is complete
            break;


        case 't':
            maintain(GO_CENTRE);
            sendCharacter('T');//Tell the PC the operation is complete
            break;


        case 'u':
            maintain(GO_DOWN);
            sendCharacter('U');//Tell the PC the operation is complete
            break;

        case 'v':
            maintain(BR_LEFT);
            sendCharacter('V');//Tell the PC the operation is complete
            break;

        case 'w':
            maintain(BR_RIGHT);
            sendCharacter('O');//Tell the PC the operation is complete
            break;

        case 'j':
            sort(RED);
            sendCharacter('J');//Tell the PC the operation is complete
            break;

        case 'k':
            sort(GREEN);
            sendCharacter('K');//Tell the PC the operation is complete
            break;

        case 'l':
            sort(BLUE);
            sendCharacter('L');//Tell the PC the operation is complete
            break;

        case '0': //Dispense all
            dispenseAll();
            sendCharacter('1');//Tell the PC the operation is complete
            break;

        case '2':
            maintain(GO_CENTRE);
            maintain(RB_CENTRE);
            sendCharacter('3');//Tell the PC the operation is complete
            break;

        case '4':
            lift();
            sendCharacter('5');//Tell the PC the operation is complete
            break;

        case 'e':
            recycle();
            sendCharacter('E');//Tell the PC the operation is complete
            break;
    }
}
/* If the serial port is readable, get a character and do something, depending on the character recieved.
 */
bool checkSerial()
{
    printLCD("");
    if(pc.readable()) {
        char c = pc.getc();
        processMessage(c);
        return true;
    } else {
        return false;
    }
}


/* Set the PC's and LCD's language to whatever our language is.
*/
void sendLanguageCharacter()
{
    switch(currentLanguage) {
        case ENGLISH:
            pc.putc('Y');
            glcd.putc(27);
            glcd.putc(15);
            glcd.putc(255);
            break;

        case FRENCH:
            pc.putc('Z');
            glcd.putc(27);
            glcd.putc(16);
            glcd.putc(255);
            break;

        case GERMAN:
            pc.putc('!');
            glcd.putc(27);
            glcd.putc(17);
            glcd.putc(255);
            break;
    }
}


