#include "mbed.h"

DigitalOut myled(LED1);
Timer tmr;
Serial pc(USBTX,USBRX);

#define RCV_MAX 32

int idx = 0;
unsigned char rcv_ary[RCV_MAX+1];

//Serial recieve callback function
void callback() {
    rcv_ary[idx++] = pc.getc();
    if( idx >= RCV_MAX )    idx = RCV_MAX - 1;
}

//clear recieve array
void clr_rcvary()
{
   int i;
    for(i=0; i<=RCV_MAX; i++)    {
        rcv_ary[i] = '\0';
    } 
    idx = 0;   
}

//main function
int main() {
    
    int d_num = 0;
    bool sio_data_flg = false;
 
    clr_rcvary();
    
    pc.attach(&callback);   //set callback function
    
    myled = 0;
 
    pc.baud(115200);                  //baudrate=115200
    pc.format(8,SerialBase::None,1);    //data length=8, parity=none, stopbit=1
    
   
    tmr.reset();
    tmr.start();
            
    while(1) {
        if ( tmr.read_ms() >= 100 )  {
            tmr.stop();
 
            //every 100 ms processing 
            if( rcv_ary[0] != '\0' )  {
                if( rcv_ary[0]=='B' && rcv_ary[1]=='G' && rcv_ary[2]=='N' && rcv_ary[3]=='\r')    {
                    sio_data_flg = true;
                    pc.printf("ACK\r\n");
                }
                else if( rcv_ary[0]=='S' && rcv_ary[1]=='T' && rcv_ary[2]=='P' && rcv_ary[3]=='\r')    {
                    sio_data_flg = false;
                    pc.printf("ACK\r\n");
                }
                else    {
                    pc.printf("NAK\r\n");
                }
                clr_rcvary();                
            }
       
            tmr.reset();
            tmr.start();
        }

        if( sio_data_flg )  {        
            pc.printf("D%03d\r\n", d_num++);     //send data
            if( d_num > 999 )   d_num = 0;
            myled = 0;
            wait_ms(200);
            myled = 1;
            wait_ms(800);
        }
        else    {
            myled = 0;
            wait_ms(1000);
            myled = 1;
            wait_ms(1000);                     
        }
 
    }
}
