#ifndef F746_NUMERIC_LABEL_OL_HPP
#define F746_NUMERIC_LABEL_OL_HPP

#include "NumericLabel.hpp"

using namespace Mikami;

namespace TakaIno
{
    template <typename T> class NumericLabelOL : public Label
    {
    public:
         // Constructor with drawing value
        NumericLabelOL(uint16_t x, uint16_t y,
                     const char fmt[], T val,
                     Label::TextAlignMode mode,
                     sFONT &fonts,
                     uint32_t textColor,
                     uint32_t backColor)
               : Label(x, y, "", mode, fonts, textColor, backColor)
  
                     
        {   Draw(fmt, val, textColor, backColor); }
        


        // Draw value
        void Draw(const char fmt[], T val, uint32_t txt_color, uint32_t bak_color)
        {
            sprintf(pri_str, fmt, val);
             Label::GetLcdPtr()->SetBackColor(bak_color);
            Label::Draw(pri_str, txt_color);
 
        }

 

    private:
        char pri_str[81];
        
        // disallow copy constructor and assignment operator
        NumericLabelOL(const NumericLabelOL&);
        NumericLabelOL& operator=(const NumericLabelOL&);
    };
}
#endif  // F746_NUMERIC_LABEL_OL_HPP
