//
//  2016/04/27, Copyright (c) 2016 Takashi Inoue 
//  Button OverLapping Class Header
//  ver 0.9 rev 0.1 2016/5/18
//-----------------------------------------------------------

#ifndef F746_GUIINIT_HPP
#define F746_GUIINIT_HPP

#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "GuiBase.hpp"

using namespace Mikami;

namespace TakaIno
{
    class GUIinit: public GuiBase
    {
      
        public:
        
          struct BackInfo       //GUI Back Infomation
            {
                uint32_t i_txtColor;
                uint32_t i_bakColor;
            };   
               
             GUIinit(           // if (No arg) then set default values
                uint16_t x =0, uint16_t y =0,
                sFONT &fonts = Font12,
                uint32_t textColor         = LCD_COLOR_RED, 
                uint32_t backColor         = LCD_COLOR_BLUE,
                uint32_t createdColor      = LCD_COLOR_GRAY,
                uint32_t touchedColor      = LCD_COLOR_WHITE,
                uint32_t inactiveColor     = LCD_COLOR_ORANGE,
                uint32_t inactiveTextColor = LCD_COLOR_GRAY
 
                   );
  
            ~GUIinit();
 
            void SetInit(sFONT &title_font, uint16_t btn_width);
                
            LCD_DISCO_F746NG* GetLcdPtrOth();
            TS_DISCO_F746NG* GetTsPtrOth();
           TS_StateTypeDef GetTsStateOth();      
                    
            bool PanelTouchedOth();
                   
        protected:
            static LCD_DISCO_F746NG *lcd_p;  // for LCD display pointer
            static TS_DISCO_F746NG *ts_p;    // for touch pannel pointer
            static TS_StateTypeDef ts_state;
              
            static uint16_t g_width;
            static uint16_t g_height_offset; 
            
            static uint16_t g_lcd_width;
            static uint16_t g_lcd_height; 
                       
            bool ts_touch_detected;
            
            BackInfo bk_info;
            
            //member variable
            uint16_t m_x, m_y;
            sFONT *m_fonts;
            uint32_t m_text_color;
            uint32_t m_back_color;
            uint32_t m_created_color;
            uint32_t m_touched_color;
            uint32_t m_inactive_color;
            uint32_t m_inactive_text_color;  
 
    };
}

#endif //F746_GUIINIT_HPP
    

