//
//  2016/04/27, Copyright (c) 2016 Takashi Inoue 
//  Button OverLapping Class Header
//  ver 0.9 rev 0.1 2016/5/17
//-----------------------------------------------------------

#ifndef F746_CIRCLE_HPP
#define F746_CIRCLE_HPP

#include "GUIinit.hpp"     //GUI init (TI)

using namespace Mikami;

namespace TakaIno
{
    class Circle : public GUIinit
    {
        public:
          struct CircleInfo       //GUI Circle Infomation
            {
                int16_t i_Xpos;
                int16_t i_Ypos;
                int16_t i_Radius;
                uint32_t i_txtColor;
                uint32_t i_bakColor;
                bool    i_move_flg;
                int16_t i_Xstep;
                int16_t i_Ystep;
                bool i_disp_c_str;
                uint32_t i_c_str_col;
                int16_t i_c_str_idx;
                string i_c_str[2];
                 sFONT *i_c_fonts;   
               uint16_t    i_lcd_width;            
            };   
            
            Circle();
 
            Circle(struct CircleInfo cirinfo);
                   
            ~Circle();
            
            bool DrawCircle(int16_t Xpos=100, int16_t Ypos=100, int16_t Radius=50,
                         uint32_t txtColor=LCD_COLOR_RED, uint32_t bakColor=LCD_COLOR_GREEN,
                         bool disp_c_str_flg=false, uint32_t c_str_col=LCD_COLOR_BLACK, 
                         int16_t str_idx = 0,
                         const string c_f_str="", const string c_b_str="",
                         sFONT &c_fonts=Font16);

            bool DrawCircle(bool dsp_circle);

            bool ReverseCircleColor();   
 
            bool DispOrEraseCircle(bool disp_flg);
            
            bool CircleTouched();  
           
            bool IsOnCircle();  
            
            bool MoveCircle(bool move_flg, int16_t xstep, int16_t ystep);
            bool MoveCircle(bool move_flg); 
                      
             bool ChangeCirclePos();
 
            uint16_t PosX(int16_t x, string str, sFONT &sfont);
 
            uint16_t CalX(int16_t x);                      
        protected:
             struct CircleInfo m_c_info;
             
 
             //sFONT &i_c_fonts;         
    };
 
 
}

#endif //F746_CIRCLE_HPP
    

