//
//  2016/04/27, Copyright (c) 2016 Takashi Inoue 
//  GUI 用定数
//  ver 0.9 rev 0.1 2016/4/27
//-----------------------------------------------------------

#ifndef F746_GUI_CONST_HPP
#define F746_GUI_CONST_HPP

#include "stm32746g_discovery_lcd.h"
#include "Circle.hpp"
#include "GuiBase.hpp"

namespace TakaIno
{
    const int G_GAME_LIMIT_TIME = 150;  //ゲーム終了時間×0.1s
    
//---- Label constant variables ----    
//作業１：　メインタイトルの文字を変えてみましょう　３０文字以内
     
    const string GUI_MAIN_TITLE = ">>> Baloon touch! Game <<<";     //メインタイトル
 
//---- Button constant variables ----    
    const int GUI_NUMBER_BUTTONS = 4;           //使用ボタンの数
                                                //ボタン上に表示する文字列
    const string GUI_BTN_STR1[GUI_NUMBER_BUTTONS] = {"Start", "End", "none",
                                                "none"
                                                };
    const uint16_t GUI_BTN_X_POS = 425;        //ボタングループ（Button Group）の最初のX座標 
    const uint16_t GUI_BTN_Y_POS = 0;        //ボタングループの最初のY座標     
    const uint16_t GUI_BTN_WIDTH = 55;          //ボタンの幅
    const uint16_t GUI_BTN_HIGHT = 40;          //ボタンの高さ       
 
    const uint16_t GUI_BTN_X_SPACE = 5;        //ボタン同士のX方向のすきま
    const uint16_t GUI_BTN_Y_SPACE = 5;        //ボタン同士のYX方向のすき
    
    const uint16_t GUI_BTN_COLUMN = 1;          //ボタンマトリクスの列の数
    
    const uint16_t GUI_FIRST_BTN_NUM = 0;       //最初のボタン番号
    
    const uint32_t GUI_BTN_BACK_COL = LCD_COLOR_GREEN;   //ボタンが押された後の背景色 

//作業２：　どの円をタッチしても加点するようにしましょう

    const int   GUI_ADD_POINT1 = 10;   //ゲームの加点１
    const int   GUI_ADD_POINT2 = 20;   //ゲームの加点２
    const int   GUI_DEME_POINT = -15;  //ゲームの減点
 
//---- Circle constant variables ---- 
//作業３：　表示する円の数を変えてみましょう　1～7
  
    const int   GUI_CIRCLE_MAX = 7;     //表示する円の数

//作業４：　円に表示する文字を変えてみましょう　４文字以内

    //表示する円の詳細な設定値
    /* X座標、Y座標、半径、表の表示色、裏の表示色、円を動かすフラグ、
    動かすときのX方向の変位、動かすときのY方向の変位、文字を表示するフラグ、文字表示色
    ｛表の表示文字、裏の表示文字｝、フォント、LCDの横幅　*/

   const struct Circle::CircleInfo DEF_CIR_INFO[ 7 ] = {
                         {50,50,35, LCD_COLOR_RED, LCD_COLOR_DARKBLUE, 
                                false,-1,-1,true, LCD_COLOR_WHITE, 0, {"ABC", "ACb"}, &Font12, 480},
                         {80,60,45, LCD_COLOR_ORANGE, LCD_COLOR_GRAY,
                                false,-1,1,true, LCD_COLOR_WHITE, 0,  {"AbC","AcB"}, &Font12, 480},
                          {120,70,35, LCD_COLOR_YELLOW, LCD_COLOR_CYAN,
                                 false,1,-1,true, LCD_COLOR_WHITE, 0, {"Abe","AKb"}, &Font12, 480},
                          {150,80,45, LCD_COLOR_GREEN, LCD_COLOR_DARKRED,
                                false,-2,1,true, LCD_COLOR_WHITE, 0,  {"AKB","ABk"}, &Font12, 480},
                         {200,90,35, LCD_COLOR_BROWN, LCD_COLOR_DARKCYAN,
                                 false,1,-2,true, LCD_COLOR_WHITE, 0,  {"Acb", "ACb"},&Font12, 480},
                         {200,100,45, LCD_COLOR_ORANGE, LCD_COLOR_DARKGREEN,
                                 false,2,1,true, LCD_COLOR_WHITE, 0,  {"ABc","aBC"}, &Font12, 480},
                         {100,100,35, LCD_COLOR_DARKRED, LCD_COLOR_GRAY,
                                 false,2,2,true, LCD_COLOR_RED, 0,  {"Abk","ABe"}, &Font12, 480}
                        };
                  
}
#endif  //F746_GUI_CONST_HPP






