//
//  2016/04/27, Copyright (c) 2016 Takashi Inoue
//  Button OverLapping Class Source File
//  ver 0.9 rev 0.1 2016/5/17
//-----------------------------------------------------------

#include "mbed.h"
#include "Circle.hpp"
#include "GUIconst.hpp"

namespace TakaIno
{
// Constructor
Circle::Circle()
{
    m_c_info.i_lcd_width = BSP_LCD_GetXSize();
}

Circle::Circle(struct CircleInfo cirinfo = DEF_CIR_INFO[0])
{
    m_c_info.i_lcd_width = BSP_LCD_GetXSize();
    m_c_info = cirinfo;
}

Circle::~Circle()
{
    ;
}

bool Circle::DrawCircle(bool dsp_circle)
{
    GetLcdPtrOth()->SetTextColor(m_c_info.i_txtColor);
    GetLcdPtrOth()->SetBackColor(m_c_info.i_bakColor);
    GetLcdPtrOth()->FillCircle((uint16_t)m_c_info.i_Xpos, (uint16_t)m_c_info.i_Ypos, (uint16_t)m_c_info.i_Radius);

    if( m_c_info.i_disp_c_str )    {
        GetLcdPtrOth()->SetTextColor(m_c_info.i_c_str_col );
        GetLcdPtrOth()->SetBackColor(m_c_info.i_txtColor);
        GetLcdPtrOth()->SetFont(m_c_info.i_c_fonts);
        GetLcdPtrOth()->DisplayStringAt(CalX(m_c_info.i_Xpos), (uint16_t)m_c_info.i_Ypos,
                                        (uint8_t *)m_c_info.i_c_str[0].c_str(), (Text_AlignModeTypdef)0x01);
    }


    return true;
}

//Draw Circle at (Xpos, Ypos)
bool Circle::DrawCircle(int16_t Xpos, int16_t Ypos, int16_t Radius, uint32_t txtColor, uint32_t bakColor,
                        bool disp_c_str_flg, uint32_t c_str_col, int16_t str_idx,
                        const string c_f_str,  const string c_b_str, sFONT &c_fonts)
{
    GetLcdPtrOth()->SetTextColor(txtColor);
    GetLcdPtrOth()->SetBackColor(bakColor);
    GetLcdPtrOth()->FillCircle((uint16_t)Xpos, (uint16_t)Ypos, (uint16_t)Radius);

    m_c_info.i_Xpos = Xpos;      //Set GUI Circle Infomation
    m_c_info.i_Ypos = Ypos;
    m_c_info.i_Radius = Radius;
    m_c_info.i_txtColor = txtColor;
    m_c_info.i_bakColor = bakColor;

    //if (display string on) then draw string
    if( disp_c_str_flg )    {
        m_c_info.i_disp_c_str = disp_c_str_flg;
        m_c_info.i_c_str_col = c_str_col;
        m_c_info.i_c_str_idx = str_idx;
        m_c_info.i_c_str[0] = c_f_str;
        m_c_info.i_c_str[1] = c_b_str;
        m_c_info.i_c_fonts = &c_fonts;

        GetLcdPtrOth()->SetTextColor(c_str_col);
        GetLcdPtrOth()->SetBackColor(m_c_info.i_txtColor);
        GetLcdPtrOth()->SetFont(m_c_info.i_c_fonts);
        GetLcdPtrOth()->DisplayStringAt(CalX(Xpos), (uint16_t)Ypos,
                                        (uint8_t *)m_c_info.i_c_str[0].c_str(), (Text_AlignModeTypdef)0x01);

    }


    return true;
}

//Reverse Circle Color (TextColor <--> BackColor))
bool Circle::ReverseCircleColor()
{
    uint32_t tmp_color;

    tmp_color = m_c_info.i_txtColor;

    GetLcdPtrOth()->SetTextColor( m_c_info.i_bakColor );
    m_c_info.i_txtColor = m_c_info.i_bakColor;

    GetLcdPtrOth()->SetBackColor(tmp_color);
    m_c_info.i_bakColor = tmp_color;

    GetLcdPtrOth()->FillCircle((uint16_t)m_c_info.i_Xpos, (uint16_t)m_c_info.i_Ypos,
                               (uint16_t)m_c_info.i_Radius );

    if( m_c_info.i_c_str_idx == 0 )   m_c_info.i_c_str_idx = 1;
    else    m_c_info.i_c_str_idx = 0;

    //if (display string on) then draw string
    if( m_c_info.i_disp_c_str )    {

        GetLcdPtrOth()->SetTextColor(m_c_info.i_c_str_col);
        GetLcdPtrOth()->SetBackColor(m_c_info.i_txtColor);

        GetLcdPtrOth()->DisplayStringAt(CalX(m_c_info.i_Xpos), (uint16_t)m_c_info.i_Ypos,
                                        (uint8_t *)m_c_info.i_c_str[m_c_info.i_c_str_idx].c_str(), (Text_AlignModeTypdef)0x01);

    }

    return true;

}

//Display or Erase Circle
bool Circle::DispOrEraseCircle(bool disp_flg)
{
    if( disp_flg )  {
        //display
        GetLcdPtrOth()->SetTextColor( m_c_info.i_txtColor );   //set current text color

        GetLcdPtrOth()->FillCircle((uint16_t)m_c_info.i_Xpos, (uint16_t)m_c_info.i_Ypos,
                                   (uint16_t)m_c_info.i_Radius );

        //if (display string on) then draw string
        if( m_c_info.i_disp_c_str )    {

            GetLcdPtrOth()->SetTextColor(m_c_info.i_c_str_col);
            GetLcdPtrOth()->SetBackColor(m_c_info.i_txtColor);
            GetLcdPtrOth()->DisplayStringAt(CalX(m_c_info.i_Xpos), (uint16_t)m_c_info.i_Ypos,
                                            (uint8_t *)m_c_info.i_c_str[m_c_info.i_c_str_idx].c_str(), (Text_AlignModeTypdef)0x01);

        }
    } else    {
        //erase
        GetLcdPtrOth()->SetTextColor( GUIinit::bk_info.i_bakColor );   //set current text color

        GetLcdPtrOth()->FillCircle((uint16_t)m_c_info.i_Xpos, (uint16_t)m_c_info.i_Ypos,
                                   (uint16_t)m_c_info.i_Radius );
    }


    return true;
}


// If panel touched, return true
bool Circle::CircleTouched()
{
    if( !PanelTouchedOth() )    return false;
    if( !IsOnCircle() ) return false;
    return true;
}

// If touched position is on the circle, return true
bool Circle::IsOnCircle()
{
    int16_t x,y,Len;
    TS_StateTypeDef tss = GetTsStateOth();


    int nTouch = multiTouch_ ? tss.touchDetected : 1;

    for (int n=0; n<nTouch; n++) {
        x = (int16_t)tss.touchX[n];
        y = (int16_t)tss.touchY[n];
        Len = (uint16_t)sqrt((double)((m_c_info.i_Xpos - x)*(m_c_info.i_Xpos - x)+
                                      (m_c_info.i_Ypos - y)*(m_c_info.i_Ypos - y)));
        if( Len <= m_c_info.i_Radius )    return true;

    }
    return false;
}

//Move circle
bool Circle::MoveCircle(bool move_flg, int16_t xstep, int16_t ystep)
{
    m_c_info.i_move_flg = move_flg;

    m_c_info.i_Xstep = xstep;
    m_c_info.i_Ystep = ystep;

    return true;
}
bool Circle::MoveCircle(bool move_flg)
{
    m_c_info.i_move_flg = move_flg;
    return true;
}

bool Circle::ChangeCirclePos()
{
//        if( m_c_info.i_Xstep != 0 || m_c_info.i_Ystep != 0)  {
    if( m_c_info.i_move_flg ) {
        GetLcdPtrOth()->SetTextColor( GUIinit::bk_info.i_bakColor );   //set current text color

        GetLcdPtrOth()->FillCircle((uint16_t)m_c_info.i_Xpos, (uint16_t)m_c_info.i_Ypos,
                                   (uint16_t)m_c_info.i_Radius );

        int16_t befo_x = m_c_info.i_Xpos;
        m_c_info.i_Xpos += m_c_info.i_Xstep;
        if( ((int32_t)g_width - (int32_t)m_c_info.i_Radius) < (int32_t)m_c_info.i_Xpos ) {
            m_c_info.i_Xpos = befo_x; //
            m_c_info.i_Xstep *= (-1);
        }
        if( (int32_t)m_c_info.i_Radius > (int32_t)m_c_info.i_Xpos ) {
            m_c_info.i_Xpos = befo_x; //
            m_c_info.i_Xstep *= (-1);
        }

        int16_t befo_y = m_c_info.i_Ypos;
        m_c_info.i_Ypos += m_c_info.i_Ystep;
        if( ((int32_t)g_lcd_height - (int32_t)m_c_info.i_Radius) < (int32_t)m_c_info.i_Ypos ) {
            m_c_info.i_Ypos = befo_y; //
            m_c_info.i_Ystep *= (-1);
        }
        if( (int32_t)(m_c_info.i_Radius + g_height_offset) > (int32_t)m_c_info.i_Ypos ) {
            m_c_info.i_Ypos = befo_y; //
            m_c_info.i_Ystep *= (-1);
        }


    }

    GetLcdPtrOth()->SetTextColor( m_c_info.i_txtColor );   //set current text color

    GetLcdPtrOth()->FillCircle((uint16_t)m_c_info.i_Xpos, (uint16_t)m_c_info.i_Ypos,
                               (uint16_t)m_c_info.i_Radius );

    //if (display string on) then draw string
    if( m_c_info.i_disp_c_str )    {

        GetLcdPtrOth()->SetTextColor(m_c_info.i_c_str_col);
        GetLcdPtrOth()->SetBackColor(m_c_info.i_txtColor);
        GetLcdPtrOth()->DisplayStringAt(CalX(m_c_info.i_Xpos), (uint16_t)m_c_info.i_Ypos,
                                        (uint8_t *)m_c_info.i_c_str[m_c_info.i_c_str_idx].c_str(), (Text_AlignModeTypdef)0x01);




    }
    return true;
}

uint16_t Circle::PosX(int16_t x, const string str, sFONT &sfont)
{
    return (uint16_t)((uint16_t)x - str.length() * sfont.Width/2);

}

uint16_t Circle::CalX(int16_t x)
{
    if( m_c_info.i_lcd_width / 2 < x )   {
        x -= m_c_info.i_lcd_width / 2;
    } else   {
        x += m_c_info.i_lcd_width / 2;
    }
    return (uint16_t)x;
}
}





