//
//  2016/04/27, Copyright (c) 2016 Takashi Inoue 
//  Button OverLapping Class Source File
//  ver 0.9 rev 0.1 2016/5/18
//-----------------------------------------------------------


#include "GUIinit.hpp"

namespace TakaIno
{
   // Constructor
  
    GUIinit::GUIinit(
        uint16_t x, uint16_t y, sFONT &fonts,
        uint32_t textColor, uint32_t backColor,
        uint32_t createdColor, uint32_t touchedColor,
        uint32_t inactiveColor, uint32_t inactiveTextColor)
        
    :GuiBase(x, y, fonts,                                       //Initializer=  GUIinit Const's args --> GuiBase Const.
                        textColor, backColor, createdColor,
                        touchedColor, inactiveColor,
                        inactiveTextColor)
                        
                        ,m_x(x), m_y(y), m_fonts(&fonts),       //member initializer  member(arg)
          m_text_color(textColor), m_back_color(backColor),
          m_created_color(createdColor),
          m_touched_color(touchedColor),
          m_inactive_color(inactiveColor),
          m_inactive_text_color(inactiveTextColor)       

    {
 
            lcd_p = GetLcdPtr();
            ts_p = GetTsPtr();
            ts_state = GetTsState();
            ts_touch_detected = ts_state.touchDetected;
            
            bk_info.i_txtColor = textColor;
           
            bk_info.i_bakColor = backColor;

           g_lcd_width = BSP_LCD_GetXSize() ;
           g_lcd_height = BSP_LCD_GetYSize() ; 
           g_width = g_lcd_width;
           g_height_offset = 0;
    }
    
    GUIinit::~GUIinit() {;}

    //GUI Resource Set Init    
    void GUIinit::SetInit(sFONT &title_font, uint16_t btn_width)
    {
        g_lcd_width = BSP_LCD_GetXSize() ;
        g_lcd_height = BSP_LCD_GetYSize() ; 
                   
        g_width = g_lcd_width - btn_width;    //X game area limit
        g_height_offset = title_font.Height;    //Y game area first
        
  
     }
  
    LCD_DISCO_F746NG* GUIinit::GetLcdPtrOth()
    {
        return lcd_p;
    }
    
    TS_DISCO_F746NG* GUIinit::GetTsPtrOth()
    {
        return ts_p;
    }

    TS_StateTypeDef GUIinit::GetTsStateOth()
    {
        ts_p->GetState(&ts_state);       
        return ts_state;
    }    
    // If panel touched, return true
    bool GUIinit::PanelTouchedOth()
    {
       ts_p->GetState(&ts_state); 
       // if (touchDetected is not changed) then return false
       if( ts_touch_detected != ts_state.touchDetected )
       {
           ts_touch_detected = ts_state.touchDetected;
           return (bool)(ts_state.touchDetected);
       }
       return false;
 
    }
    
    
    LCD_DISCO_F746NG *GUIinit::lcd_p;
    TS_DISCO_F746NG *GUIinit::ts_p;
    
    TS_StateTypeDef GUIinit::ts_state;

    uint16_t GUIinit::g_width;
    uint16_t GUIinit::g_height_offset; 
            
    uint16_t GUIinit::g_lcd_width;
    uint16_t GUIinit::g_lcd_height; 
                
  
    //bool GUIinit::ts_touch_detected;
    bool ts_touch_detected;    
}




