//--------------------------------------------------------------------------------
//  バルーンタッチゲーム・プログラム
//
//
//  date:   2016/04/27
//  rev 0.9   date: 2016/5/18
//  rev 1.0   2016/6/8
//  rev 1.1     2016/7/2
//  author: Copyright (c) 2016 Takashi Inoue
//--------------------------------------------------------------------------------
#include "main1.hpp"       //

extern GUIinit  guiobj;
extern  Circle cirary[GUI_CIRCLE_MAX];
extern  ButtonGroupOL btnary;
extern  NumericLabelOL<int> timeobj;

extern int  g_bln_num;  //バルーン表示個数
extern  int g_game_time;        //ゲーム時間用変数
extern  int g_game_prcs;        //ゲーム中のプロセス変数、最初は待機プロセス

extern void gui_init(void);
//extern  void dsp_main_title(string main_title); // メインタイトルの表示
extern  void dsp_main_title(char main_title[]); // メインタイトルの表示
extern  void dsp_baloon(void);  //バルーン表示

extern  void btn_init(void);    //ボタン初期化
extern  bool chk_btn_tch(int btn_num);  //あるボタン番号のボタンタッチを調べる
extern  void set_btn_act_inact(bool act_ary[]); //ボタンの有効無効をセットする

extern  void set_new_rand(void);    //新しい乱数値をセットする
extern  void chk_baloon_rand(int idx, int *score);//idx番目のバルーンが、２つの乱数と一致していれば加点、違っていれば減点する     
extern  bool chk_baloon_tch(int idx);   //idx番のバルーンに触ったかどうかチェックする
extern  void rvs_baloon_col(int idx);   //idx番のバルーンの色を反転する
extern  void chg_baloon_pos(int idx);    //idx番のバルーンの表示位置を動かす   
extern  void ena_baloon_mov(int idx, bool mov_flg); //idx番のバルーンの表示位置を動かすことを許可する
                
extern  void init_game_time(void);  //ゲーム時間表示の初期化
extern  void dsp_game_time(void);   //ゲーム中プロセスであれば、残り時間の表示

extern  void init_game_score(void); //ゲーム得点の初期化
extern  void dsp_game_score(int score); //ゲーム得点の表示

extern void TimerIsr();     //タイマ割り込みハンドラ
//0.1秒毎のタイマ割り込みを有効にする
extern  void ena_tim_irt(double tim_intvl);

//----- メイン関数 -----------------------------
int main()
{
    int btn_num = 0;        //今回押されたボタンの番号
    int befo_btn_num = -1;  //前回押されたボタンの番号
/*課題6 */    bool btn_act_ary[4] = {true, false, false, false};     //ボタンの有効フラグを入れる配列
    int score = 0;     //ゲーム点数     
    int idx;            //各種配列操作用添え字

     gui_init(); //グラフィック初期化
     
     g_bln_num = 7;    //バルーン表示個数設定
     
    //ボタン初期化     
    set_btn_act_inact(btn_act_ary); //ボタンの有効無効をセットする         
         
 /*課題5 */   // メインタイトルの表示
    dsp_main_title("+++ Baloon Touch! GAME +++");   // メインタイトルの表示
 
 /**/ //ゲーム時間の表示
     init_game_time();  //ゲーム時間表示の初期化
 
    //ゲーム得点の表示
     init_game_score();   //ゲーム得点表示の初期化    

 /**/
    dsp_baloon();  //バルーン表示 
 
     ena_tim_irt(0.1f); //0.1秒毎のタイマ割り込みを有効にする
    
 /*課題4*/  //無限ループ
    while(1) {
        //ボタン番号btn_numのボタンタッチを調べる
        if( chk_btn_tch(btn_num) == true )  {            
            //ボタンが押され、１回目に押されたボタンと異なっていたら処理を行う
            if( befo_btn_num != btn_num )   {
                //今回押されたボタン番号を、１回前に押されたボタン番号として保存する
                 befo_btn_num = btn_num;
                
 /*課題2*/         switch(btn_num) {       //ボタン番号により処理を分ける
                    case 0:     //［start］ボタンが押された
                        btn_act_ary[0] = false;   //ボタン0（start）を無効にする
                        btn_act_ary[1] = true;     //ボタン1（end）を有効にする
                        set_btn_act_inact(btn_act_ary); //ボタンの有効無効をセットする                       

 /*課題3*/                 //すべての円の移動を開始する
                        for( idx=0; idx < g_bln_num; idx++) {
                             //idx番のバルーンの表示位置を動かすことを許可する
                            ena_baloon_mov(idx, true);
                        }
                        score = 0;      //得点を0クリア
 
                        set_new_rand();    //新しい２つの乱数値をセットする
                        
                        g_game_time = 0;    //ゲーム時間を0クリア
                        g_game_prcs = 1;    //ゲーム中プロセスにする
                        
                        break;
                    case 1:     //［end］ボタンが押された
                        g_game_prcs = 2;    //ゲーム終了プロセスにする
                        
                        btn_act_ary[1] = false;   //ボタン1（end）を無効にする
                        btn_act_ary[0] = true;     //ボタン0（start）を有効にする
                        set_btn_act_inact(btn_act_ary); //ボタンの有効無効をセットする       
                                               
                         befo_btn_num = -1;  //1回前に押されたボタンは無しとする

                        //すべてのバルーンの移動を停止する
                        for( idx=0; idx < g_bln_num; idx++) {
                            //idx番のバルーンの表示位置を動かすことを禁止する
                            ena_baloon_mov(idx, false);
                        }

                        g_game_prcs = 0;    //待機プロセスにする

                        break;
                     default:
                        break;
                }
            }
        }
/* 課題7*/
        btn_num++;  //ボタン番号を増加
        if( btn_num >= GUI_NUMBER_BUTTONS ) btn_num=0;  //ボタン番号範囲内に限定する

        if( g_game_prcs == 1 )    {         //ゲーム中プロセスであれば以下の処理を行う

             for( idx=0; idx < g_bln_num; idx++) {
                //idx番のバルーンの表示位置を動かす
                chg_baloon_pos(idx);       
                                 
                //idx番のバルーンに触ったかどうかチェックする
                if( chk_baloon_tch(idx) )   {
                  
                    rvs_baloon_col(idx);    //idx番のバルーンの色を反転する

                    chk_baloon_rand(idx, &score);  //idx番目のバルーンが、２つの乱数と一致していれば加点、違っていれば減点する                 
                 }
            }
            
           //ゲーム中プロセスであれば、残り時間の表示
             dsp_game_time();

            //ゲーム中プロセスであれば、得点の表示
             dsp_game_score(score);           
          
        }

        //以下は、タイマにより、ゲームが終了する場合の処理
        if( g_game_prcs == 2 ) {
            btn_act_ary[1] = false;   //ボタン1（end）を無効にする
            btn_act_ary[0] = true;     //ボタン0（start）を有効にする
            set_btn_act_inact(btn_act_ary); //ボタンの有効無効をセットする       
                        
            befo_btn_num = -1;  //1回前に押されたボタンは無しとする

            //すべての円の移動を停止する
            for( idx=0; idx < g_bln_num; idx++) {
                 //idx番のバルーンの表示位置を動かすことを禁止する
               ena_baloon_mov(idx, false);
            }
            g_game_prcs = 0;    //待機プロセスにする
        }

        wait(0.01f);      //10ms待つ

    }
}









