#include "mbed.h"

#include "BlinkLabel.hpp"
#include "ButtonGroup.hpp"
#include "SeekbarGroup.hpp"
#include "Label.hpp"

#include "GUIconst.hpp"     //GUI用定数  (TI)
#include "GUIinit.hpp"     //GUI初期化 (TI)
#include "ButtonGroupOL.hpp"     //ButtonGroupオーバーラップクラス (TI)
#include "NumericLabelOL.hpp"   //Numerical Labelオーバーラップクラス (TI)
#include "Circle.hpp"     //GUI 円クラス (TI)
#include "Rand.hpp"   //乱数発生クラス (TI)

using namespace Mikami;     //Mikami　名前空間を使用
using namespace TakaIno;    //TakaIno 名前空間を使用 (TI)

Ticker timer;                 //タイマ割り込み

GUIinit     guiobj;      //GUIクラスオブジェクト生成
Circle cirary[ GUI_CIRCLE_MAX ]={DEF_CIR_INFO[0], DEF_CIR_INFO[1],DEF_CIR_INFO[2], DEF_CIR_INFO[3],
                        DEF_CIR_INFO[4], DEF_CIR_INFO[5],DEF_CIR_INFO[6]};
ButtonGroupOL btnary;    //ButtonGroupOLクラスオブジェクトの生成     
Rand    rndobj;         //乱数発生クラスオブジェクト生成
//ゲーム時間表示
Label lb_time_obj(425,205, "Time", Label::LEFT, Font16, LCD_COLOR_YELLOW, LCD_COLOR_BLUE);   //
NumericLabelOL<int> timeobj(425, 220, "%03d", G_GAME_LIMIT_TIME, Label::LEFT, Font16, LCD_COLOR_WHITE, LCD_COLOR_DARKBLUE);
//ゲーム得点表示
Label lb_score_obj(425,235, "Score", Label::LEFT, Font16, LCD_COLOR_CYAN, LCD_COLOR_BLUE);   //
NumericLabelOL<int> scoreobj(425, 250, "%04d", 0, Label::LEFT, Font16, LCD_COLOR_RED, LCD_COLOR_WHITE);
              
uint16_t btn_width = GUI_BTN_WIDTH;     //ボタン表示の幅
int     g_btn_num = 4;      ////ボタンの個数
int     g_bln_num = GUI_CIRCLE_MAX;
int     rndary[2], befo_rndary[2] = {-1,-1};      //今回と前回の乱数値用配列

int g_game_time = 0;        //ゲーム時間用変数
int g_game_prcs = 0;        //ゲーム中のプロセス変数、最初は待機プロセス

//タイマ割り込みハンドラ
void TimerIsr()
{
    if( g_game_prcs == 1 )    {     //「ゲーム中プロセス」時に処理する
        g_game_time++;      //ゲーム時間をカウントアップ
        if( g_game_time > G_GAME_LIMIT_TIME ) {
            //ゲーム終了時間になったら「ゲーム終了プロセス」にする
            g_game_time = G_GAME_LIMIT_TIME;
            g_game_prcs = 2;
        }
    }
}   
//グラフィック初期化   
void gui_init(void)
{
  //GUIオブジェクトで、フォント16とボタン幅をセット
    guiobj.SetInit(Font16, btn_width);
}

// メインタイトルの表示
//void dsp_main_title(string main_title)
void dsp_main_title(char main_title[])
{
    string str = main_title;
    // メインタイトルの表示、中央位置、フォント16
    Label title_obj(0,0, main_title, Label::CENTER, Font16);   //   
}

//バルーン表示
void dsp_baloon(void)
{
 //円オブジェクトにより、円を描画する
    for( int idx = 0; idx < g_bln_num; idx++ ) {
        cirary[idx].DrawCircle(true);
    }    
}

//idx番のバルーンに触ったかどうかチェックする
bool chk_baloon_tch(int idx)
{
    return cirary[idx].CircleTouched();
}

//idx番のバルーンの色を反転する
void rvs_baloon_col(int idx)
{
      //idx番目の円を触ったら、円の色を反転する
      cirary[idx].ReverseCircleColor();
}

//idx番のバルーンの表示位置を動かす
void chg_baloon_pos(int idx)
{
       cirary[idx].ChangeCirclePos();
}

//idx番のバルーンの表示位置を動かすことを許可する
void ena_baloon_mov(int idx, bool mov_flg)
{
       cirary[idx].MoveCircle(mov_flg);
 }


//ボタン初期化
void btn_init()
{
     //ボタン1（end）,2,3を無効に  ボタン0（start）を有効のままにする
    btnary.Inactivate(1);    btnary.Inactivate(2);    btnary.Inactivate(3);
  
 }
 
 //ボタンの有効無効をセットする
 void set_btn_act_inact(bool act_ary[])
 {
     for( int i = 0; i < g_btn_num; i++)
     {
        if( act_ary[i] )   {
           btnary.Activate(i); 
        }
        else   {
           btnary.Inactivate(i);
        }   
     } 
 }
 
//あるボタン番号のボタンタッチを調べる
bool chk_btn_tch(int btn_num)
{
    return btnary.Touched(btn_num);     
}

//新しい乱数値をセットする
void set_new_rand(void)
{
   //乱数用配列に、１回前と異なった乱数値を入れる
    for( int idx=0; idx < 2; idx++) {
        do {
           rndary[idx] = (int)rndobj.GetRand(g_bln_num);
        } while( rndary[idx]==befo_rndary[idx]);
        befo_rndary[idx] = rndary[idx];
    }    
}


//idx番目のバルーンが、２つの乱数と一致していれば加点、違っていれば減点する                 
void chk_baloon_rand(int idx, int *score)
{
        if( idx == rndary[0] )  *score += GUI_ADD_POINT1;//乱数0と一致している円であれば、加点
        else if (idx == rndary[1] ) *score += GUI_ADD_POINT2;//乱数1と一致している円であれば、加点
        else    *score += GUI_DEME_POINT;    //それ以外の円であれば、減点    
}

//ゲーム時間表示の初期化
void init_game_time(void)
{
    g_game_time = 0;
}

 //ゲーム中プロセスであれば、残り時間の表示
void dsp_game_time(void)
{
    timeobj.Draw("%03d", G_GAME_LIMIT_TIME - g_game_time,LCD_COLOR_WHITE, LCD_COLOR_DARKBLUE);
 }          

//ゲーム得点の初期化
void init_game_score(void)
{
    ;
}

 //ゲーム得点の表示
void dsp_game_score(int score)
{
    if( score >= 0 )    {
        scoreobj.Draw("%04d", score, LCD_COLOR_BLACK, LCD_COLOR_GREEN);
    } else    {
        scoreobj.Draw("%04d", score, LCD_COLOR_WHITE, LCD_COLOR_RED);
    }   
}

//0.1秒毎のタイマ割り込みを有効にする
void ena_tim_irt(double tim_intvl)
{
    timer.attach(&TimerIsr, tim_intvl);      //0.1秒ごとのタイマ割り込みを有効にする     
    
}         
    
    