/*******************************************************************
 *
 *  File: MbedTransport.h
 *
 *  Description: Communications transport layer API for Mbed
 *
 *  Copyright 2015 Innomatix, LLC., All Rights Reserved
 *
 *  THIS DOCUMENT AND ITS CONTENTS ARE INTELLECTUAL PROPERTY
 *  OF INNOMATIX, LLC.  ANY DUPLICATION IN PART OR WHOLE
 *  WITHOUT PRIOR WRITTEN CONSENT IS STRICTLY PROHIBITED.
 *
 *******************************************************************/
#ifndef _MBEDTRANSPORT_H_ 
#define _MBEDTRANSPORT_H_ 


#define DO_SERIAL_NET

#ifndef DO_SERIAL_NET
#include "EthernetInterface.h"
#endif


#define ADDRESS_LENGTH 256


typedef struct
{
    char                Address[ADDRESS_LENGTH];
    int                 Port;
#ifndef DO_SERIAL_NET
    UDPSocket           sendSocket;                    
    UDPSocket           receiveSocket;                 
    Endpoint            sendEndpoint;                  
    Endpoint            receiveEndpoint;
#endif
   
}TransportHandle_t, *TransportHandle_p;

/**
* Function to initialize ethernet, UDP socket sending and UDP socket receiving. 
*   
* @param h - TransportHandle that saves all of the socket information for future
                use when we need to send/recieve information.
* @retval result - lets us know if there was a success or error.
***********************************************************************************/
int TransportInit( TransportHandle_p handle, const char *address, unsigned short port );



/***********************************************************************************/
void TransportClose( TransportHandle_p handle );


/**
* Test if the transport is ready to use.  Ensures that TransportInit() has been
* called for the given handle.  May include other conditions based on the underlying
* interface/connection.
*       serial_net - includes testing that the DAP side of the connection is open
*
* NOTE: calls to TransportSend() and TransportReceive() when the transport reports
*   not Ready() may block.
*
* @retval result - 0 indicates not ready or not connected.  1 indicates ready to use
***********************************************************************************/
int TransportReady( TransportHandle_p handle );


/**
* Function for sending a buffer via UDP with the socket we set up in Init. 
*   
* @param len - length of the buffer we want to send to the server.
* @param buff - the buffer we would like to send to the server.
* @retval result - Value < 0 indicates error or no remote device connected.  Value >= 0 indicates number bytes sent
******************************************************************************************/
int TransportSend( TransportHandle_p handle, unsigned short len, const unsigned char *buff, int timeout);


/**
* Function for receving a buffer via UDP with the socket we set up in Init. 
*   
* @param maxlen - the maximum length of the buffer we want to receive from the server.
* @param buff - the buffer we would like to receiver from the server.
* @retval result - Value < 0 indicates error or no remote device connected.  Value >= 0 indicates number bytes received
***********************************************************************************************/
int TransportReceive( TransportHandle_p handle, unsigned short maxlen, unsigned char *buff, int timeout );


#endif /* _MBEDTRANSPORT_H_ */