/*******************************************************************
 *
 *  File: updateclient_api.h
 *
 *  Description: Coprocessor Update Client public API per specification document
 *
 *  Copyright 2015 Innomatix, LLC., All Rights Reserved
 *
 *  THIS DOCUMENT AND ITS CONTENTS ARE INTELLECTUAL PROPERTY
 *  OF INNOMATIX, LLC.  ANY DUPLICATION IN PART OR WHOLE
 *  WITHOUT PRIOR WRITTEN CONSENT IS STRICTLY PROHIBITED.
 *
 *******************************************************************/
#ifndef _UPDATECLIENT_API_H
#define _UPDATECLIENT_API_H
 
typedef enum
{
    statusSuccess = 0x00,
    statusUpdateAvailable = 0x01,
    statusNoUpdate = 0x02,
    statusInvalidId = 0x03,
    statusInvalidOffset = 0x04,
    statusInvalidLength = 0x05,
    statusInvalidChecksum = 0x06,
    statusNameMismatch = 0x07,
    statusDuplicateVersion = 0x08,
    statusAbortUpdate = 0x09,
    statusNoConnection = 0x0a,
    statusTimeout = 0x0b
}UpdateStatus_e;

// Use the __attribute__((unused)) to supress the "unused variable" warning
static const char *UpdateStatusNames[] __attribute__((unused)) =
{
    "Success", "UpdateAvailable", "NoUpdate", "InvalidID", "InvalidOffset",
    "InvalidLength", "InvalidChecksum", "NameMismatch", "DuplicateVersion", 
    "AbortUpdate", "NoConnection", "Timeout"
};



/*************************************************/
 

/**
    This function initializes the API and sets up the Update Client.  

    Return Values:
       TRUE  client was able to setup the network and bind to the desired port
       FALSE  an error has occurred, the client is not functional
*********************************************************************/
UpdateStatus_e UpdateInit( const char *address, unsigned short port );



/**
    Shutdown and clean up the Update Client
*********************************************************************/
void UpdateClose();



/**
    Check for a pending update, compare versions to see if it should
    be applied, receive, validate and apply the update.  Report the
    results to the client.

    Return Values:
       TRUE - an update was performed successfully.  Reboot is needed.
       FALSE - no update was pending, a pending update duplicates the
            current application, a pending update was unsuccessful.
            No further action is necessary regarding the update.
*********************************************************************/
UpdateStatus_e PerformUpdate( int timeout_msec );


#endif /* _UPDATECLIENT_API_H */
 
