/*******************************************************************
 *
 *  File: InnomatixMeta.h
 *
 *  Description: Macros for creating metadata tags that get embedded in the binary
 *
 *  Copyright 2015 Innomatix, LLC., All Rights Reserved
 *
 *  THIS DOCUMENT AND ITS CONTENTS ARE INTELLECTUAL PROPERTY
 *  OF INNOMATIX, LLC.  ANY DUPLICATION IN PART OR WHOLE
 *  WITHOUT PRIOR WRITTEN CONSENT IS STRICTLY PROHIBITED.
 *
 *******************************************************************/
#ifndef _INNOMATIX_META_H
#define _INNOMATIX_META_H


// These macros provide tags that allow the InnomatixData host to locate useful
//  strings within the compiled binary.  The strings will be used to assist with
//  system configuration and revision control
#define TFMETA( tag, str )    "<TFMETA>" tag "=" str "</TFMETA>"

// This metadata is used by the InnomatixData host to identify this as an MBED binary
// Use the __attribute__((unused)) to supress the "unused variable" warning
static const char *PlatformMeta = TFMETA( "TYPE", "LPC1768" );
static char dummyP = *PlatformMeta;


// The InnomatixData host requires the VERSION and DESC metadata values.
// Applications should use these macros to provide an appropriate string.
#define TFVERSION( str )      TFMETA( "VERSION", str )
#define TFDESCRIPTION( str )  TFMETA( "DESC", str )


#endif /* _INNOMATIX_META_H */
