/*******************************************************************
 *
 *  File: NBO.h
 *
 *  Description: Library to get Network to Host byte order and 
 *                   vice versa.
 *
 *  Copyright 2015 Innomatix, LLC., All Rights Reserved
 *
 *  THIS DOCUMENT AND ITS CONTENTS ARE INTELLECTUAL PROPERTY
 *  OF INNOMATIX, LLC.  ANY DUPLICATION IN PART OR WHOLE
 *  WITHOUT PRIOR WRITTEN CONSENT IS STRICTLY PROHIBITED.
 *
 ********************************************************************/
#ifndef _NBO_H_
#define _NBO_H_

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif


/**
* Function to aid the MessageBuilders and ParseHelpers Libraries. It allows user 
*    to get a 32 bit number in Network Byte Order to host byte order (little endian).
*   
* @param network - 32 bit number in network byte order.
* @retval host - the 32 bit number in host byte order.
***************************************************************************************/
uint32_t ntohl( uint32_t network);

/**
* Function to aid the MessageBuilders and ParseHelpers Libraries. It allows user 
*   to get a 32 bit number in host byte order (little endian) to network byte order.
*   
* @param host - 32 bit number in host byte order.
* @retval network - the 32 bit number network byte order.
**************************************************************************************/
uint32_t htonl( uint32_t host);

/**
* Function to aid the MessageBuilders and ParseHelpers Libraries. It allows user 
*   to get a 16 bit number host byte order (little endian) to network byte order.
*   
* @param host - 16 bit number in host byte order.
* @retval network - the 16 bit number in network byte order.
**************************************************************************************/
uint16_t htons( uint16_t host);

/**
* Function to aid the MessageBuilders and ParseHelpers Libraries. It allows user 
*    to get a 16 bit number in Network Byte Order to host byte order (little endian).
*   
* @param network - 16 bit number in network byte order.
* @retval host - the 16 bit number in host byte order.
**************************************************************************************/
uint16_t ntohs( uint16_t network);


#ifdef __cplusplus
}
#endif

#endif // _NBO_H__