#include "mbed.h"

#define SCX18_I2C_BASE_ADDR 0x74 // DS-SCX18.S I2C base address
#define SCX18_SERVO_ENABLED (1 << 7)
#define SCX18_SERVO_REVERSED (1 << 6)
#define SCX18_SERVO_SOFT_START (1 << 5)
#define SCX18_SERVO_SPEED_CONTROL (1 << 4)
#define SCX18_SERVO_MOVEMENT (1 << 4)

union SCX18SServoStatusRegister {
    uint8_t value;
    struct {
        bool enabled;
        bool reversed;
        bool softstart;
        bool movement;
        uint8_t unpopulated : 4;
    } bits;
};

class SCX18S
{
    I2C i2c;
    uint8_t i2c_address;
    void writeRegister(uint8_t reg, uint8_t value);
    uint8_t readRegister(uint8_t reg);

public:
    SCX18S(PinName p_sda, PinName p_scl, bool j_a0 = true, bool j_a1 = true);

    SCX18SServoStatusRegister readStatus(uint8_t channel);
    void writePosition(uint8_t channel, uint8_t position);
    void writeControl(uint8_t channel, bool enabled, bool reversed, bool softstart, bool speedcontrol, uint8_t speed);
    void writeEnable();
};