/*
 ***************************************************************************
 * File Name    : EEPROM24LC01.cpp
 *
 * Revision     : 1.0
 * Notes        :
 * Target Board : mbed LPC824
 *
 * Revision History:
 ***************************************************************************
 */
#include "EEPROM24LC01.h"
#include "mbed.h"

EEPROM24LC01::EEPROM24LC01(I2C *i2c, const int address):
    _i2c_address(address<<1), _i2c(i2c)
{
}

int EEPROM24LC01::byte8_write(char *data)
{
    int res;
    char buf[9];
    int i = 0;

    buf[0] = 0;        // Address

    for(i=0;i<8;++i){
        buf[i+1] = data[i];
    }
/*    buf[1] = data[0];
    buf[2] = data[1];
    buf[3] = data[2];
    buf[4] = data[3];
    buf[5] = data[4];
    buf[6] = data[5];
    buf[7] = data[6];
    buf[8] = data[7];
*/
    res = _i2c->write(_i2c_address, buf, sizeof(buf), false);

    wait_ms(5);         // 5mS

    return res;
}


int EEPROM24LC01::readAll( char *data, int size )
{
    int res;
    char buf[1];

    buf[0] = 0;        // Read Address High byte set
    res = _i2c->write(_i2c_address, buf, sizeof(buf), true);
    res = _i2c->read(_i2c_address, (char *)data, size, false);

    return res;
}
