#include "mbed.h"
#include "EEPROM24LC01.h"

//#define def_myAddress 0x8001

//Bus switch
//TC7MBL3125 nOE
//#define GateClose 1
//#define GateOpen 0

//TC7MBL3126 OE
#define GateClose 0
#define GateOpen 1


#define OffFET 0
#define OnFET 1
#define HOLD 0xff
#define ALL_HOLD 0xff
#define NOTHOLD 0

//#define test 1
//#define ROMtest 1
//#define debug 1

//#define SPIfreq 2000000
#define SPIfreq 17000000

I2C i2c(I2C_SDA,I2C_SCL);        // sda, scl
EEPROM24LC01 eeprom(&i2c, 0x50);

//DigitalOut myGate(P0_21,0);
DigitalOut Gate1_1(P0_14,1);
DigitalOut Gate1_2(P0_23,1);
DigitalOut Gate1_3(P0_21,1);
DigitalOut Gate1_4(P0_22,1);
DigitalOut Gate2_MISO(P0_20,1);
DigitalOut Gate2_MOSI(P0_19,1);
DigitalOut Gate2_SCK(P0_17,1);
DigitalOut Gate2_4(P0_13,1);

DigitalInOut myIO1(P0_1);//ng
DigitalInOut myIO2(P0_28);
DigitalInOut myIO3(P0_27);
DigitalInOut myIO4(P0_26);

DigitalOut myFET(P0_6,0);

DigitalIn iAddress1(P0_8);
DigitalIn iAddress2(P0_9);

DigitalOut myled(LED2,0);

#ifdef debug
Serial pc(USBTX, USBRX); // tx, rx
#endif

//SPISlave device(P0_26, P0_25, P0_24, P0_15); // mosi, miso, sclk, ssel
//SPISlave device(P0_25, P0_26, P0_24, P0_15); // mosi, miso, sclk, ssel
SPISlave device(P0_25, P0_18, P0_24, P0_15); // mosi, miso, sclk, ssel

uint8_t address[4];
uint8_t exData[3];
uint8_t gateData;
uint32_t def_myAddress;
uint32_t def_searchAddress;

void closeAllGate(void);

#ifdef test
void spiTest(void){
    device.reply(0x00);              // Prime SPI with first reply
    printf("SPI slave test\r\n");
    while(1) {
        if(device.receive()) {
            int v = device.read();   // Read byte from master
            printf("Recieve = %d\r\n",v);
            //v = (v + 1) % 0x100;     // Add one to it, modulo 256
            device.reply(v+1);         // Make this the next reply
            printf("reply = %d\r\n",v);
        }
    }
}

void IoTest(void){
    int inData[4];
    int inAddr1,inAddr2;
    
    myIO1.input();
    myIO2.input();
    myIO3.input();
    myIO4.input();
    
    printf("IoTest\r\n");
    
    while(1){
        
        inAddr1 = iAddress1;
        inAddr2 = iAddress2;
        if(inAddr1 == 0){
            myIO1.input();
            myIO2.input();
            myIO3.input();
            myIO4.input();
            myIO1.mode(PullNone);
            myIO2.mode(PullNone);
            myIO3.mode(PullNone);
            myIO4.mode(PullNone);
            inData[0] = myIO1;
            inData[1] = myIO2;
            inData[2] = myIO3;
            inData[3] = myIO4;
            printf("inData[0] = %d\r\n",inData[0]);
            printf("inData[1] = %d\r\n",inData[1]);
            printf("inData[2] = %d\r\n",inData[2]);
            printf("inData[3] = %d\r\n\r\n",inData[3]);
        }else{
            printf("myIOs output\r\n");
            myIO1.output();
            myIO2.output();
            myIO3.output();
            myIO4.output();
            myIO1.mode(PullUp);
            myIO2.mode(PullUp);
            myIO3.mode(PullUp);
            myIO4.mode(PullUp);
            myIO1 = 1;
            myIO2 = 1;
            myIO3 = 1;
            myIO4 = 1;
        }
        printf("inAddr1 = %d\r\n",inAddr1);
        printf("inAddr2 = %d\r\n",inAddr2);
        
        
        Gate1_1 = 1;
        Gate1_2 = 1;
        Gate1_3 = 1;
        Gate1_4 = 1;
        Gate2_MISO = 1;
        Gate2_MOSI = 1;
        Gate2_SCK = 1;
        //Gate2_4 = 1;
        myFET = 1;
        myled = 1;
        
        
        wait(1);
        
        if(inAddr1==1){
            myIO1 = 0;
            myIO2 = 0;
            myIO3 = 0;
            myIO4 = 0;
        }
        
        Gate1_1 = 0;
        Gate1_2 = 0;
        Gate1_3 = 0;
        Gate1_4 = 0;
        Gate2_MISO = 0;
        Gate2_MOSI = 0;
        Gate2_SCK = 0;
        //Gate2_4 = 0;
        myFET = 0;
        myled = 0;
        
        wait(1);
        
    }
    
}

#endif


#ifdef ROMtest
void EEPROMtest(void){
    char bufData[10];
    
    printf("write test\n\r");
    
    bufData[0]=0x80;//address1
    bufData[1]=0x00;//address2
    bufData[2]=0x00;//address3
    bufData[3]=0x0D;//address4
    bufData[4]=0x04;//extra data
    bufData[5]=0x05;//extra data
    bufData[6]=0x06;//extra data
    bufData[7]=0x07;//gate open pattern number
    eeprom.byte8_write( bufData);
    
    bufData[0]=0xAA;
    
    printf("end\n\r");
    
    
    bufData[0]=0;
    bufData[1]=0;
    bufData[2]=0;
    bufData[3]=0;
    bufData[4]=0;
    bufData[5]=0;
    bufData[6]=0;
    bufData[7]=0;
    
    
    eeprom.readAll( bufData, 8 );
    
    printf("0:%02x\n\r",bufData[0]);
    printf("1:%02x\n\r",bufData[1]);
    printf("2:%02x\n\r",bufData[2]);
    printf("3:%02x\n\r",bufData[3]);
    printf("4:%02x\n\r",bufData[4]);
    printf("5:%02x\n\r",bufData[5]);
    printf("6:%02x\n\r",bufData[6]);
    printf("7:%02x\n\r",bufData[7]);
    
    printf("\n\r Read again! \n\r\n\r");
    
    
    eeprom.readAll( bufData, 8 );
    
    printf("0:%02x\n\r",bufData[0]);
    printf("1:%02x\n\r",bufData[1]);
    printf("2:%02x\n\r",bufData[2]);
    printf("3:%02x\n\r",bufData[3]);
    printf("4:%02x\n\r",bufData[4]);
    printf("5:%02x\n\r",bufData[5]);
    printf("6:%02x\n\r",bufData[6]);
    printf("7:%02x\n\r",bufData[7]);
    
    printf("\nend\n\r");   
    

    while(1);
}
#endif

void ReadDataFromEEPROM(void){
    int i;
    char bufData[8];
    char buf;
    char buf1,buf2;
    
    eeprom.readAll( bufData, 8 );
#ifdef debug    
    printf("0:%02x\n\r",bufData[0]);
    printf("1:%02x\n\r",bufData[1]);
    printf("2:%02x\n\r",bufData[2]);
    printf("3:%02x\n\r",bufData[3]);
    printf("4:%02x\n\r",bufData[4]);
    printf("5:%02x\n\r",bufData[5]);
    printf("6:%02x\n\r",bufData[6]);
    printf("7:%02x\n\r",bufData[7]);
#endif
    
    for(i=0;i<4;++i){
        address[i] = bufData[i];
        def_myAddress = (def_myAddress<<8) + bufData[i];
#ifdef debug    
        printf("address%d : %02x\n\r",i,address[i]);
#endif
    }
#ifdef debug    
    printf("def_myAddress %08x\n\r",def_myAddress);
#endif

    buf = 0;
    buf1 = iAddress1.read();
    if(buf1==0){
        buf1 = 1;
    }else if(buf1==1){
        buf1 = 0;
    }
    buf = buf1;

//    buf = iAddress1.read();

    
    buf2 = iAddress2.read();
    if(buf2==0){
        buf2 = 1;
    }else if(buf2==1){
        buf2 = 0;
    }
    
    buf = (buf<<1) + buf2;

//    buf = (buf<<1) + iAddress2.read();
    
    def_myAddress += buf;

#ifdef debug    
    printf("def_myAddress %08x\n\r",def_myAddress);
#endif
    
    for(i=4;i<7;++i){
        exData[i-4] = bufData[i];
#ifdef debug    
        printf("exData%d : %02x\n\r",i-4,exData[i-4]);
#endif
    }
    
    gateData = bufData[7];
#ifdef debug    
    printf("gateData : %02x\n\r",gateData);
#endif

    def_searchAddress = (def_myAddress & 0x3FFFFFFF) + 0x40000000;

    
}

/*
void holdMode(int data){
    int inData[4];
    
    myIO1.input();
    myIO2.input();
    myIO3.input();
    myIO4.input();
    
    if(data == NOTHOLD){
        myIO1.mode(PullNone);
        myIO2.mode(PullNone);
        myIO3.mode(PullNone);
        myIO4.mode(PullNone);
        
        myled = 0;
    
    }else if(data == HOLD){
        
        myIO1.mode(PullDown);
        myIO2.mode(PullDown);
        myIO3.mode(PullDown);
        myIO4.mode(PullDown);
        
        //read
        inData[0] = myIO1;
        inData[1] = myIO2;
        inData[2] = myIO3;
        inData[3] = myIO4;
        //printf("inData[1]=%d\r\n",inData[1]);
        
        //closeAllGate();
        
        //hold
        myIO1.output();
        myIO2.output();
        myIO3.output();
        myIO4.output();
        
        myIO1.mode(PullUp);
        myIO2.mode(PullUp);
        myIO3.mode(PullUp);
        myIO4.mode(PullUp);
        
        myIO1 = inData[0];
        myIO2 = inData[1];
        myIO3 = inData[2];
        myIO4 = inData[3];
        
        myled = 1;
        
    }
}
*/

void holdIOs(int select, int readData){
        
        if(select == 1){
            myIO1.mode(PullDown);
            //hold
            myIO1.output();
            myIO1.mode(PullUp);
            myIO1 = readData;
            
        }else if(select == 2){
            myIO2.mode(PullDown);
            //hold
            myIO2.output();
            myIO2.mode(PullUp);
            myIO2 = readData;
            
        }else if(select == 3){
            myIO3.mode(PullDown);
            //hold
            myIO3.output();
            myIO3.mode(PullUp);
            myIO3 = readData;
            
        }else if(select == 4){
            myIO4.mode(PullDown);
            //hold
            myIO4.output();
            myIO4.mode(PullUp);
            myIO4 = readData;
            
        }
    
}

void holdMode(uint16_t data){
    int inData[4];
    uint8_t data8,dataBuf;
    data8 = data;
    //printf("data = %d, data8 = %d\r\n",data,data8);
    
    myIO1.input();
    myIO2.input();
    myIO3.input();
    myIO4.input();
    //read
    inData[0] = myIO1;
    inData[1] = myIO2;
    inData[2] = myIO3;
    inData[3] = myIO4;
    //printf("inData[0]=%d\r\n",inData[0]);
    //printf("inData[1]=%d\r\n",inData[1]);
    
    if(data == NOTHOLD){
        //printf("NOTHOLD\r\n");
        myIO1.mode(PullNone);
        myIO2.mode(PullNone);
        myIO3.mode(PullNone);
        myIO4.mode(PullNone);
        
        myled = 0;
        
    }else if(data == ALL_HOLD){
        //printf("ALL_HOLD\r\n");
        holdIOs(1,inData[0]);
        holdIOs(2,inData[1]);
        holdIOs(3,inData[2]);
        holdIOs(4,inData[3]);
        
        myled = 1;
    }else{
        dataBuf = data8 & 0b00000001;
        if(dataBuf == 1){
            //printf("data 1\r\n");
            holdIOs(1,inData[0]);
        }
        
        dataBuf = (data8>>1) & 0b00000001;
        if(dataBuf == 1){
            //printf("data 2\r\n");
            holdIOs(2,inData[1]);
        }
        
        dataBuf = (data8>>2) & 0b00000001;
        if(dataBuf == 1){
            //printf("data 3\r\n");
            holdIOs(3,inData[2]);
        }
        
        dataBuf = (data8>>3) & 0b00000001;
        if(dataBuf == 1){
            //printf("data 4\r\n");
            holdIOs(4,inData[3]);
        }
    }
}





void closeAllGate(void){
    
            Gate1_1 = GateClose;
            Gate1_2 = GateClose;
            Gate1_3 = GateClose;
            Gate1_4 = GateClose;
            Gate2_MISO = GateClose;
            Gate2_MOSI = GateClose;
            Gate2_SCK = GateClose;
            Gate2_4 = GateClose;
            myFET = OffFET;
}

void writeMode1(uint16_t mode1, uint16_t mode2){
    
    switch(mode1){
        case 0x01:
            holdMode(NOTHOLD);
            //close all gate
            myFET = OffFET;
            //myGate = GateClose;
            closeAllGate();
            myled = 0;
#ifdef debug
            printf("close gate\r\n");
#endif
            break;
            
        case 0x02:
            //open gate normal IOs
            closeAllGate();
            myFET = OffFET;
            //myGate = GateOpen;
            Gate1_1 = GateOpen;
            Gate1_2 = GateOpen;
            Gate1_3 = GateOpen;
            Gate1_4 = GateOpen;
            holdMode(NOTHOLD);
            myled = 1;
#ifdef debug
            printf("open gate\r\n");
#endif
            break;
            
        case 0x03:
            //Detect mode ON
            //myGate = GateClose;
            closeAllGate();
            wait_ms(0.01);
            myFET = OnFET;
            myled = 1;
#ifdef debug
            printf("Detect mode ON\r\n");
#endif
            break;
            
        case 0x04:
            //Detect mode OFF
            //myGate = GateClose;
            closeAllGate();
            wait_ms(0.01);
            myFET = OffFET;
            myled = 0;
#ifdef debug
            printf("Detect mode OFF\r\n");
#endif
            break;
            
        case 0x05://LED on
            myled = 1;
#ifdef debug
            printf("LED ON\r\n");
#endif
            break;
            
        case 0x06://LED off
            myled = 0;
#ifdef debug
            printf("LED OFF\r\n");
#endif
            break;
            
        case 0x07://SPI gate : MOSI MISO SCK CS
            closeAllGate();
            Gate2_MOSI = GateOpen;
            Gate2_MISO = GateOpen;
            Gate2_SCK = GateOpen;
            Gate1_4 = GateOpen;
            holdMode(NOTHOLD);
            myled = 1;
            break;
            
        case 0x08://One way SPI gate : MOSI SCK CS EXtra IO
            closeAllGate();
            Gate2_MOSI = GateOpen;
            Gate1_2 = GateOpen;
            Gate2_SCK = GateOpen;
            Gate1_4 = GateOpen;
            holdMode(NOTHOLD);
            myled = 1;
            
            break;
            
        case 0x09://SCK as a clock : SCK Extra IOs
            closeAllGate();        
            Gate1_1 = GateOpen;
            Gate1_2 = GateOpen;
            Gate2_SCK = GateOpen;
            Gate1_4 = GateOpen;
            holdMode(NOTHOLD);
            myled = 1;
        
            break;
            
        case 0x0A://SPI gate : MISO SCK CS
            closeAllGate();        
            Gate1_1 = GateOpen;
            Gate2_MISO = GateOpen;
            Gate2_SCK = GateOpen;
            Gate1_4 = GateOpen;
            holdMode(NOTHOLD);
            myled = 1;
        
            break;
            
        case 0x0B://hold mode ON
            //holdMode(HOLD);
            holdMode(mode2);
            closeAllGate();
            break;
            
        case 0x0C://hold mode OFF
            holdMode(NOTHOLD);
            //closeAllGate();
            break;
            
        default:
            myFET = OffFET;
            //myGate = GateClose;
            closeAllGate();
            holdMode(NOTHOLD);
#ifdef debug
            printf("default\r\n");
#endif
            myled = 0;
            break;
    }
}


void writeMode2(uint16_t mode2){
    //not yet
    
}

void resetAll(void){
    myFET = OffFET;
    //myGate = GateClose;
    closeAllGate();
    myled = 0;
}

int main() {
    uint8_t flg_mode = 0;
    uint16_t SpiRdata = 0;
    //uint16_t SpiAddr = 0;
    uint32_t SpiAddr = 0;
    uint16_t SpiIoNo = 0;
    uint16_t SpiWrite = 0;
    uint8_t resetCounter = 0;
    uint8_t flg_ResetMode = 0;

#ifdef ROMtest
    EEPROMtest();
    while(1){
        ;
    }
#endif

#ifdef test
    while(1){
        holdMode(0b00001001);
        wait(1);
        holdMode(0b00000110);
        wait(1);
        holdMode(0b00000101);
        wait(1);
        holdMode(0b00001010);
        wait(1);
    }
    spiTest();
    IoTest();
#endif
    
    myIO1.input();
    myIO2.input();
    myIO3.input();
    myIO4.input();
    myIO1.mode(PullNone);
    myIO2.mode(PullNone);
    myIO3.mode(PullNone);
    myIO4.mode(PullNone);
    
    myled = 1;
    wait(0.1);
    myled = 0;
    wait(0.1);
    myled = 1;
    wait(0.1);
    myled = 0;
    wait(0.1);
    
    //myUart.printf("test OK /r/n");
    //EEPROMtest();
    
    ReadDataFromEEPROM();
    
    //def_myAddress=0x80000001;
    //while(1);
    
    myFET = OffFET;
    //myGate = GateClose;
    closeAllGate();
    
    myled = 0;
    device.format(8,0);
    device.frequency(SPIfreq);
    
    device.reply(0x00);              // Prime SPI with first reply
    
/*
holdMode(HOLD);
while(1){
    ;
    }
*/  
  
    while(1) {
        flg_ResetMode = 0;
        if(device.receive()) {
            SpiRdata = device.read();
#ifdef debug
            printf("device.receive() SpiRdata = %d\r\n",SpiRdata);
            printf("flg_mode = %d\r\n",flg_mode);
#endif
            //myled = 1;
            if(SpiRdata == 0x00){
                ++resetCounter;
                if(resetCounter >= 6){
            //if((SpiRdata == 0x00)&&(flg_mode != 1)){//reset
                    flg_mode = 0;
                    SpiAddr = 0;
                    SpiIoNo = 0;
                    SpiWrite = 0;
                    resetCounter = 0;
                    flg_ResetMode = 1;
                    
                    //resetAll();
                    myled = 1;
                    wait(0.1);
                    myled = 0;
                    wait(0.1);
                    myled = 1;
                    wait(0.1);
                    myled = 0;
                    wait(0.1);
#ifdef debug
                    printf("reset\r\n");
#endif
                }
                
            }else{
                resetCounter = 0;
            }
                
            //}else{//select mode
                
                if((flg_mode == 0) && (flg_ResetMode == 0)) {//read address data
                    SpiAddr = SpiRdata;
                    flg_mode = 1;
#ifdef debug
                    printf("0 flg_mode = %d\r\n",flg_mode);
#endif
                }else if(flg_mode == 1) {//read address data
                    SpiAddr = (SpiAddr<<8) + SpiRdata;
                    flg_mode = 11;
#ifdef debug
                    printf("1 flg_mode = %d\r\n",flg_mode);
#endif
                }else if(flg_mode == 11) {//read address data
                    SpiAddr = (SpiAddr<<8) + SpiRdata;
                    flg_mode = 12;
#ifdef debug
                    printf("11 flg_mode = %d\r\n",flg_mode);
#endif
                }else if(flg_mode == 12) {//read address data
                    SpiAddr = (SpiAddr<<8) + SpiRdata;
                    flg_mode = 2;
#ifdef debug
                    printf("12 flg_mode = %d\r\n",flg_mode);
#endif
                }else if(flg_mode == 2) {//read address data
                    SpiIoNo = SpiRdata;
                    flg_mode = 3;
#ifdef debug
                    printf("2 flg_mode = %d\r\n",flg_mode);
#endif
                }else if(flg_mode == 3) {//read fpga write data
                    SpiWrite = SpiRdata;
                    flg_mode = 0;
#ifdef debug
                    printf("3 flg_mode = %d\r\n",flg_mode);
                    printf("SpiAddr = %d\r\n",SpiAddr);
                    printf("SpiAddr = %08x\r\n",SpiAddr);
                    printf("SpiIoNo = %d\r\n",SpiIoNo);
                    printf("SpiWrite = %d\r\n",SpiWrite);
#endif
                    
                    //Select mode
                    if(SpiAddr == def_myAddress){
#ifdef debug
                        printf("Select mode\r\n");
#endif
                        writeMode1(SpiIoNo,SpiWrite);
                        //writeMode2(SpiWrite);
                        //myled = 1;
                        
                        /*while(1) {
                            for(int i=0;i<SpiIoNo;++i){
                                myled = 1;
                                wait(0.2);
                                myled = 0;
                                wait(0.2);
                            }
                            myled = 1;
                            wait(1);
                            myled = 0;
                            wait(1);
                        }*/
                        
                        flg_mode = 0;
                        SpiAddr = 0;
                        SpiIoNo = 0;
                        SpiWrite = 0;
                        
                    }else if((SpiAddr < 0x80000000)&&(SpiAddr <= def_searchAddress)){
                        writeMode1(SpiIoNo,SpiWrite);
                        //writeMode2(SpiWrite);
                    }else{//not this address
                        //flug reset
                        flg_mode = 0;
                        SpiAddr = 0;
                        SpiIoNo = 0;
                        SpiWrite = 0;
                        myled = 0;
#ifdef debug
                        printf("Not me\r\n");
#endif
                     
                    }
                }
            
        }
    }
}
