#include "mbed.h"
#include "EEPROM24LC01.h"

//#define ROMtest 1
//#define debug 1
//#define debug2 1
//#define test 1

#define def_myAddress 0x80000000
//#define SPIfreq 2000000
////#define BaseSPIfreq 4170000
#define BaseSPIfreq 17000000
////#define BaseSPIfreq 8000000

#define MAX_INOUT   16
#define MAX_BANK    20

#define NOTHOLD 0
#define HOLD_10 1
#define HOLD_01 2
#define ALL_HOLD 3

#ifdef debug2
//Serial pc(USBTX, USBRX);
Serial pc(P0_4, P0_0);
#endif

I2C i2c(I2C_SDA,I2C_SCL);        // sda, scl
EEPROM24LC01 eeprom(&i2c, 0x50);

DigitalOut addr0(P0_8);
DigitalOut addr1(P0_13);
DigitalOut addr2(P0_9);
DigitalOut addr3(P0_27);
DigitalOut addr4(P0_14);

DigitalOut WData0(P0_21);
//DigitalOut WData1(P0_7);///ERRROR
DigitalOut WData1(P0_17);//change
DigitalOut WData2(P0_22);
DigitalOut WData3(P0_20);
DigitalOut WData4(P0_19);

//DigitalOut WLatch(P0_18);//ERROR
DigitalOut WLatch(P0_23);//change

/*
DigitalIn RData0(P0_14);
//DigitalIn RData1(P0_23);
DigitalIn RData1(P0_18);//change
DigitalIn RData2(P0_28);
DigitalIn RData3(P0_11);
DigitalIn RData4(P0_9);

DigitalOut RLatch(P0_6);
*/

DigitalOut myled(P0_16,0);
SPISlave device(P0_26, P0_25, P0_24, P0_15); // mosi, miso, sclk, ssel
DigitalOut MRESET(P0_1);

DigitalInOut myIO1(P0_6);
DigitalInOut myIO2(P0_28);

#ifdef test
DigitalIn iAddress1(P0_15);
#endif

uint8_t address[4];
uint8_t exData[3];
uint8_t gateData;
uint32_t mod_myAddress;



#ifdef ROMtest
void EEPROMtest(void){
    char bufData[10];
    
    printf("write test\n\r");
    
    bufData[0]=0xC0;//address1
    bufData[1]=0x00;//address2
    bufData[2]=0x00;//address3
    bufData[3]=0x01;//address4
    bufData[4]=0x04;//extra data
    bufData[5]=0x05;//extra data
    bufData[6]=0x06;//extra data
    bufData[7]=0x07;//gate open pattern number
    int res = eeprom.byte8_write( bufData);
    //printf("write res = %d\r\n",res);
    
    bufData[0]=0xAA;
    
    printf("end\n\r");
    
    
    bufData[0]=0;
    bufData[1]=0;
    bufData[2]=0;
    bufData[3]=0;
    bufData[4]=0;
    bufData[5]=0;
    bufData[6]=0;
    bufData[7]=0;
    
    
    eeprom.readAll( bufData, 8 );
    
    printf("0:%02x\n\r",bufData[0]);
    printf("1:%02x\n\r",bufData[1]);
    printf("2:%02x\n\r",bufData[2]);
    printf("3:%02x\n\r",bufData[3]);
    printf("4:%02x\n\r",bufData[4]);
    printf("5:%02x\n\r",bufData[5]);
    printf("6:%02x\n\r",bufData[6]);
    printf("7:%02x\n\r",bufData[7]);
    
    printf("\n\r Read again! \n\r\n\r");
    
    
    eeprom.readAll( bufData, 8 );
    
    printf("0:%02x\n\r",bufData[0]);
    printf("1:%02x\n\r",bufData[1]);
    printf("2:%02x\n\r",bufData[2]);
    printf("3:%02x\n\r",bufData[3]);
    printf("4:%02x\n\r",bufData[4]);
    printf("5:%02x\n\r",bufData[5]);
    printf("6:%02x\n\r",bufData[6]);
    printf("7:%02x\n\r",bufData[7]);
    
    printf("\nend\n\r");   
    

    while(1);
}
#endif

void ReadDataFromEEPROM(void){
    int i,res;
    char bufData[8];
    //char buf;
    //char buf1,buf2;
    
    res = eeprom.readAll( bufData, 8 );
    if(res == 0){
#ifdef debug    
        printf("0:%02x\n\r",bufData[0]);
        printf("1:%02x\n\r",bufData[1]);
        printf("2:%02x\n\r",bufData[2]);
        printf("3:%02x\n\r",bufData[3]);
        printf("4:%02x\n\r",bufData[4]);
        printf("5:%02x\n\r",bufData[5]);
        printf("6:%02x\n\r",bufData[6]);
        printf("7:%02x\n\r",bufData[7]);
#endif
    
        for(i=0;i<4;++i){
            address[i] = bufData[i];
            mod_myAddress = (mod_myAddress<<8) + bufData[i];
#ifdef debug    
            printf("address%d : %02x\n\r",i,address[i]);
#endif
        }
#ifdef debug    
        printf("mod_myAddress %08x\n\r",mod_myAddress);
#endif
    
        for(i=4;i<7;++i){
            exData[i-4] = bufData[i];
#ifdef debug    
            printf("exData%d : %02x\n\r",i-4,exData[i-4]);
#endif
        }
    
        gateData = bufData[7];
#ifdef debug    
        printf("gateData : %02x\n\r",gateData);
#endif

        return;
        
    }else if(res == 1){
        for(i=0;i<4;++i){
            address[i] = 0;
        }
        return;
    }
}




#ifdef test
void IoTest(void){
    int inData[2];
    int inAddr1 = 0;
    
    myIO1.input();
    myIO2.input();
    
    printf("IoTest\r\n");
    
    while(1){
        
        inAddr1 = iAddress1;
        if(inAddr1 == 0){
            printf("myIOs input\r\n");
            myIO1.input();
            myIO2.input();
            myIO1.mode(PullNone);
            myIO2.mode(PullNone);
            inData[0] = myIO1;
            inData[1] = myIO2;
            printf("inData[0] = %d\r\n",inData[0]);
            printf("inData[1] = %d\r\n",inData[1]);
        }else{
            printf("myIOs output\r\n");
            myIO1.output();
            myIO2.output();
            myIO1.mode(PullUp);
            myIO2.mode(PullUp);
            myIO1 = 1;
            myIO2 = 1;
        }
        
        
        
        wait(1);
        
        if(inAddr1==1){
            myIO1 = 0;
            myIO2 = 0;
        }
        
        
        wait(1);
        
    }
    
}

#endif


void holdIOs(int select, int readData){
        
        if(select == 1){
            myIO1.mode(PullDown);
            //hold
            myIO1.output();
            myIO1.mode(PullUp);
            myIO1 = readData;
            
        }else if(select == 2){
            myIO2.mode(PullDown);
            //hold
            myIO2.output();
            myIO2.mode(PullUp);
            myIO2 = readData;
            
        }
    
}

void holdeMode(int data){
    int inData[2];
    
    myIO1.input();
    myIO2.input();
    //read
    inData[0] = myIO1;
    inData[1] = myIO2;
    //printf("inData[0]=%d\r\n",inData[0]);
    //printf("inData[1]=%d\r\n",inData[1]);
    
    if(data == NOTHOLD){
        //printf("NOTHOLD\r\n");
        myIO1.mode(PullNone);
        myIO2.mode(PullNone);
        
        myled = 0;
    
    }else if(data == HOLD_10){
        //printf("HOLD_10\r\n");
        holdIOs(1,inData[0]);
        
        myled = 1;
        
    }else if(data == HOLD_01){
        //printf("HOLD_01\r\n");
        holdIOs(2,inData[1]);
        
        myled = 1;
        
    }else if(data == ALL_HOLD){
        //printf("ALL_HOLD\r\n");
        holdIOs(1,inData[0]);
        holdIOs(2,inData[1]);
        
        myled = 1;
        
    }
}





void writeReg(uint16_t addr, uint16_t writeData){
    
    addr0 = (addr & 0x0001);
    addr1 = ((addr >> 1)&0x001);
    addr2 = ((addr >> 2)&0x001);
    addr3 = ((addr >> 3)&0x001);
    addr4 = ((addr >> 4)&0x001);
    
    WData0 = (writeData & 0x0001);
    WData1 = ((writeData >> 1)&0x001);
    WData2 = ((writeData >> 2)&0x001);
    WData3 = ((writeData >> 3)&0x001);
    WData4 = ((writeData >> 4)&0x001);
    
    WLatch = 0;
    wait_us(0.1);
    WLatch = 1;
    
    //pc.printf("addr = %x\r\n",addr);
    
    //pc.printf("writeData = %x\r\n",writeData);
    
    //pc.printf("\r\nwrite Data addr1\r\n");
    
}


/*
uint16_t readReg(uint16_t addr){
    
    uint16_t myReadData = 0;
    
    addr0 = (addr & 0x0001);
    addr1 = ((addr >> 1)&0x001);
    addr2 = ((addr >> 2)&0x001);
    addr3 = ((addr >> 3)&0x001);
    addr4 = ((addr >> 4)&0x001);
    
    RLatch = 0;
    wait_ms(0.01);
    RLatch = 1;
    wait_ms(0.01);
    
    myReadData += RData0;
    myReadData += (RData1 << 1);
    myReadData += (RData2 << 2);
    myReadData += (RData3 << 3);
    myReadData += (RData4 << 4);
    
    //pc.printf("read Data addr1 = 5'b %d\r\n",myReadData);
    
    return myReadData;
}
*/


void resetAll(void){
    int i;
    for(i=0;i<=15;++i){
        writeReg(i,0);
    }
}


int main() {
    uint8_t flg_mode = 0;
    uint16_t SpiRdata = 0;
    //uint16_t SpiAddr = 0;
    uint32_t SpiAddr = 0;
    uint16_t SpiIoNo = 0;
    uint16_t SpiWrite = 0;
    uint8_t resetCounter = 0;
    uint8_t flg_ResetMode = 0;
    uint8_t nextSend = 0;
    
    address[0] = 0x80;
    address[1] = 0x00;
    address[2] = 0x00;
    address[3] = 0x00;
    
    //ReadDataFromEEPROM();
    
    myIO1.input();
    myIO2.input();
    myIO1.mode(PullNone);
    myIO2.mode(PullNone);

    myled = 1;
    wait(0.1);
    myled = 0;
    wait(0.1);
    myled = 1;
    wait(0.1);
    myled = 0;
    wait(0.1);
    
#ifdef test
    while(1){
        holdeMode(0);
        wait(1);
        holdeMode(1);
        wait(1);
        //holdeMode(2);
        //wait(1);
        //holdeMode(3);
        //wait(1);
    }
    
    while(1){
        IoTest();
    }
#endif
    
#ifdef ROMtest
    EEPROMtest();
    while(1){
        ;
    }
#endif
/*
    writeReg(0x01,0x01);
    writeReg(0x02,0x02);
    writeReg(0x03,0x03);
    writeReg(0x04,0x04);
//    writeReg(0x07,0x07);//error
    
    while(1){
        myled = 1;
        wait(0.1);
        myled = 0;
        wait(0.1);
        wait(1);
    }
*/

    MRESET = 0;
    wait_ms(100);
    MRESET = 1;
    
    device.format(8,0);
    device.frequency(BaseSPIfreq);
    
    device.reply(0x00);              // Prime SPI with first reply
    myled = 0;
    
    while(1) {
        flg_ResetMode = 0;
        if(device.receive()) {
            SpiRdata = device.read();
            device.reply(nextSend); // Make this the next reply
            

#ifdef debug
            printf("device.receive() SpiRdata = %d\r\n",SpiRdata);
            printf("flg_mode = %d\r\n",flg_mode);
#endif
            //myled = 1;
            if(SpiRdata == 0x00){
                nextSend = 0x00;
                ++resetCounter;
                if(resetCounter >= 6){
            //if((SpiRdata == 0x00)&&(flg_mode != 1)){//reset
                    flg_mode = 0;
                    SpiAddr = 0;
                    SpiIoNo = 0;
                    SpiWrite = 0;
                    resetCounter = 0;
                    flg_ResetMode = 1;
                    
                    //resetAll();
                    myled = 1;
                    wait(0.1);
                    myled = 0;
                    wait(0.1);
                    myled = 1;
                    wait(0.1);
                    myled = 0;
                    wait(0.1);
#ifdef debug
                    printf("reset\r\n");
#endif
                }
                
            }else{
                resetCounter = 0;
            }
                
            //}else{//select mode
                
                if((flg_mode == 0) && (flg_ResetMode == 0)) {//read address data
                    SpiAddr = SpiRdata;
                    nextSend = address[0];
                    flg_mode = 1;
                    
#ifdef debug
                    printf("0 flg_mode = %d\r\n",flg_mode);
#endif
                }else if(flg_mode == 1) {//read address data
                    SpiAddr = (SpiAddr<<8) + SpiRdata;
                    nextSend = address[1];
                    flg_mode = 11;
#ifdef debug
                    printf("1 flg_mode = %d\r\n",flg_mode);
#endif
                }else if(flg_mode == 11) {//read address data
                    SpiAddr = (SpiAddr<<8) + SpiRdata;
                    nextSend = address[2];
                    flg_mode = 12;
#ifdef debug
                    printf("11 flg_mode = %d\r\n",flg_mode);
#endif
                }else if(flg_mode == 12) {//read address data
                    SpiAddr = (SpiAddr<<8) + SpiRdata;
                    nextSend = address[3];
                    flg_mode = 2;
#ifdef debug
                    printf("12 flg_mode = %d\r\n",flg_mode);
#endif
                }else if(flg_mode == 2) {//read address data
                    SpiIoNo = SpiRdata;
                    nextSend = 0x00;
                    flg_mode = 3;
#ifdef debug
                    printf("2 flg_mode = %d\r\n",flg_mode);
#endif
                }else if(flg_mode == 3) {//read fpga write data
                    SpiWrite = SpiRdata;
                    flg_mode = 0;
#ifdef debug2
                    pc.printf("3 flg_mode = %d\r\n",flg_mode);
                    pc.printf("SpiAddr = %d\r\n",SpiAddr);
                    pc.printf("SpiAddr = %08x\r\n",SpiAddr);
                    pc.printf("SpiIoNo = %d\r\n",SpiIoNo);
                    pc.printf("SpiWrite = %d\r\n",SpiWrite);
#endif
                    
                    //Select mode
                    if(SpiAddr == def_myAddress){
#ifdef debug
                        printf("Select mode\r\n");
#endif
//printf("Select mode;SpiAddr = 0x%X, SpiIoNo = 0x%X, SpiWrite = 0x%X\r\n",SpiAddr,SpiIoNo,SpiWrite);

                        if(SpiWrite == 0xee){//read from eeprom address
                            ReadDataFromEEPROM();
                        }else if(SpiWrite == 0xcc){//hold mode
                            holdeMode(SpiIoNo);
                        }else{//set register
                            writeReg(SpiIoNo,SpiWrite);
                        }
                        //writeMode1(SpiIoNo);
                        //writeMode2(SpiWrite);
                        myled = 1;
                        
                        /*while(1) {
                            for(int i=0;i<SpiIoNo;++i){
                                myled = 1;
                                wait(0.2);
                                myled = 0;
                                wait(0.2);
                            }
                            myled = 1;
                            wait(1);
                            myled = 0;
                            wait(1);
                        }*/
                        
                        flg_mode = 0;
                        SpiAddr = 0;
                        SpiIoNo = 0;
                        SpiWrite = 0;
                        
                    //}else if(SpiAddr == mod_myAddress){
                    //    writeReg(SpiIoNo,SpiWrite);
                    //    myled = 1;
                    //    flg_mode = 0;
                    //    SpiAddr = 0;
                    //    SpiIoNo = 0;
                    //    SpiWrite = 0;
                        
                            
                    }else{//not this address
                        //flug reset
                        flg_mode = 0;
                        SpiAddr = 0;
                        SpiIoNo = 0;
                        SpiWrite = 0;
                        myled = 0;
#ifdef debug
                        printf("Not me\r\n");
#endif
                     
                    }
                }
            
        }
    }
}
