#include "mbed.h"
#include "max31855.h"

DigitalOut myled(LED1);

//----------------------------------------------------------
//SPI Interfaces
//SPI testSPI(p11,p12,p13);//MOSI MISO SCK for LPC1768
SPI testSPI(P0_26,P0_25,P0_24);//MOSI MISO SCK for LPC824MAX
//----------------------------------------------------------

//----------------------------------------------------------
//Thermocouples
//max31855 max1(testSPI,p21);
max31855 max1(testSPI,P0_15);//Digital Out LPC824MAX
//----------------------------------------------------------

//----------------------------------------------------------
//Reflow Oven
DigitalOut oOven(P0_27);
//FUN
DigitalOut oFan(P0_13);

//----------------------------------------------------------

float getTemp(void){
    float fvalue = 0.0;
    if (max1.ready()==1){
        //Get the reading
        fvalue = max1.read_temp();
        //fvalue = fvalu;
        //fvalue = fvalue *2 -160.0; //calibration here
        //fvalue = fvalue; //calibration here
        if((fvalue >= 2000)&&(fvalue <= 2010)){
            printf("Plobe error : maybe wire is cut. stop all\r\n");
            oOven = 0;
            oFan = 0;
        }else{
            printf("Temp: %4.2f\n\r", fvalue);
            myled = !myled;
            return fvalue;
        }
    }else{
        printf("Can not get Temp\n\r");
        return -1;//error can not get temp
        
    }
}

void keepCool(void){
    oOven = 0;
    oFan = 1;
    
    for(int i=0;i<60;++i){
        printf("cooling t:%d ",i);
        getTemp();
        wait(1);
        
    }//1 min wait for cool
}

int stage1(void){ //upto 150 degree Celsius
    float nowTemp = 0;
    
    oOven = 1;
    oFan = 0;
    
    while(1){
        printf("stage1 ");
        nowTemp = getTemp();
        if(nowTemp >= 150){
            oOven = 0;//stop oven 
            return 1;
        }
        wait(0.5);
    }
}

int stage2(void){ //keep 180 degree Celsius for 100 sec
    int time = 0;
    float nowTemp = 0;

    oOven = 0;
    oFan = 1;
    
    for(time = 0; time < (100.0 / 0.3); ++time){
        printf("stage2 time=%4.2lf",(time*0.3));
        nowTemp = getTemp();
        
        if(nowTemp > 180.0){
            oOven = 0;
            oFan = 0;
            wait(0.05);;
            oOven = 0;
            oFan = 1;
            wait(0.1);
            oOven = 0;
            oFan = 0;
            wait(0.05);;
            oOven = 0;
            oFan = 1;
            wait(0.1);
        }else{
            oOven = 1;
            oFan = 1;
            wait(0.05);
            oOven = 1;
            oFan = 0;
            wait(0.1);
            oOven = 1;
            oFan = 1;
            wait(0.05);
            oOven = 1;
            oFan = 0;
            wait(0.1);
        }
    }
    
 return 1;   
}


int stage3(void){ //Go to 260 degree Celsius!
    int time = 0;
    float nowTemp = 0;
   
    
    oOven = 0;
    oFan = 1;
    while(1){
        printf("stage3 ");
        nowTemp = getTemp();
        
        if(nowTemp >= 260.0){
            return 1;
        }else{
            oOven = 1;
            oFan = 1;
            wait(0.05);
            oOven = 1;
            oFan = 0;
            wait(0.75);
            
        }
    }
    return -1;//error
}

int main() {
    //Initialise chip (starts internal timer)
    max1.initialise();
    
    //Float value to hold temperature returned
    float fvalue = 0;
    
    //keepCool();
    stage1();
    stage1();
    stage1();
    stage2();
    stage3();
    stage3();
    stage3();
    keepCool();
    keepCool();
    keepCool();
    printf("end of Process! Thank you for Using Techshop Reflow.\r\n");
 
}
