#include "mbed.h"

#include "MCUGearBaseM.h"
#include "MCUGearM.h"
#include "commonM.h"

Serial pc(USBTX, USBRX); // tx, rx Set BaudRate = 115200 in main()


void setIOBank0(MCUGear *mcugear);
void setIOBank1(MCUGear *mcugear);
void setIOBank2(MCUGear *mcugear);
void setIOBank3(MCUGear *mcugear);
void setIOBank4(MCUGear *mcugear);
void setIOBank5(MCUGear *mcugear);
void setIOBank6(MCUGear *mcugear);
void setIOBank7(MCUGear *mcugear);

DigitalOut myled(LED1);

MCUGear UniM(p28, p27, N_VDD_VDD_VDD);       //2 Connector Universal Module

DigitalOut Dout1(p16);
DigitalOut Dout2(p21);
DigitalOut Dout3(p22);
DigitalOut Dout4(p23);
DigitalOut Dout5(p24);

DigitalIn Din1(p9);
DigitalIn Din2(p10);

int main() {
    
    int sw1 = 0;
    int sw2 = 0;
    int nowBank = 0;
    
    initBase(); //initialize Baseboard
    
    //set schematic select 0-7
    int location = UniM.detectModule();    //save location data in MCUGear class and you can check return data.Baseboard has 0-47 pin.
    printf("location = %d\n", &location);
    
    startReg(0);
    setIOBank0(&UniM);//make schematic Bank0
    endReg(0);
    
    
    startReg(1);
    setIOBank1(&UniM);//make schematic Bank1
    endReg(1);
    
    startReg(2);
    setIOBank2(&UniM);//make schematic Bank2
    endReg(2);
    
    startReg(3);
    setIOBank3(&UniM);//make schematic Bank3
    endReg(3);
    
    startReg(4);
    setIOBank4(&UniM);//make schematic Bank4
    endReg(4);
    
    startReg(5);
    setIOBank5(&UniM);//make schematic Bank5
    endReg(5);
    
    startReg(6);
    setIOBank6(&UniM);//make schematic Bank6
    endReg(6);
    
    startReg(7);
    setIOBank7(&UniM);//make schematic Bank7
    endReg(7);

    changeBank(0);//select Bank
    
    while(1) {
        
        UniM.connectModule();
        sw1 = Din1.read();
        sw2 = Din2.read();
        printf("sw1 = %d  sw2 = %d\r\n",sw1,sw2);

        Dout1 = 0;
        Dout2 = 1;
        Dout3 = 1;
        wait(0.3);
        
        Dout1 = 1;
        Dout2 = 0;
        Dout3 = 1;
        wait(0.3);
        
        Dout1 = 1;
        Dout2 = 1;
        Dout3 = 0;
        wait(0.3);
      
        UniM.disconnectModule();
        
        if(sw1==0){//chage Bank
            ++nowBank;
            if(nowBank >= 8){
                nowBank = 0;
            }
            changeBank(nowBank);
            printf("nowBank = %d\r\n",nowBank);
        }
        
        
    }
}


void setIOBank0(MCUGear *mcugear){
    mcugear->setWire(IO_MBED_P9, IO_REG_IN_DIR, 0);
    mcugear->setWire(IO_MBED_P10, IO_REG_IN_DIR, 1);
}

void setIOBank1(MCUGear *mcugear){
    mcugear->setWire(IO_MBED_P10, IO_REG_IN_DIR, 0);
    mcugear->setWire(IO_MBED_P9, IO_REG_IN_DIR, 1);
}

void setIOBank2(MCUGear *mcugear){
    mcugear->setWire(IO_MBED_P9, IO_REG_IN_DIR, 0);
    mcugear->setWire(IO_MBED_P10, IO_REG_IN_DIR, 1);
    mcugear->setWire(IO_MBED_P16, IO_REG_OUT_DIR, 4);
    mcugear->setWire(IO_MBED_P21, IO_REG_OUT_DIR, 3);
    mcugear->setWire(IO_MBED_P22, IO_REG_OUT_DIR, 2);
}

void setIOBank3(MCUGear *mcugear){
    mcugear->setWire(IO_MBED_P10, IO_REG_IN_DIR, 0);
    mcugear->setWire(IO_MBED_P9, IO_REG_IN_DIR, 1);
    mcugear->setWire(IO_MBED_P16, IO_REG_OUT_DIR, 2);
    mcugear->setWire(IO_MBED_P21, IO_REG_OUT_DIR, 3);
    mcugear->setWire(IO_MBED_P22, IO_REG_OUT_DIR, 4);
}

void setIOBank4(MCUGear *mcugear){
    mcugear->setWire(IO_MBED_P9, IO_REG_IN_DIR, 0);
    mcugear->setWire(IO_MBED_P10, IO_REG_IN_DIR, 1);
    mcugear->setWire(IO_MBED_P16, IO_REG_OUT_DIR, 4);
    mcugear->setWire(IO_MBED_P21, IO_REG_OUT_DIR, 3);
    mcugear->setWire(IO_MBED_P22, IO_REG_OUT_DIR, 2);
}


void setIOBank5(MCUGear *mcugear){
    mcugear->setWire(IO_MBED_P10, IO_REG_IN_DIR, 0);
    mcugear->setWire(IO_MBED_P9, IO_REG_IN_DIR, 1);
    mcugear->setWire(IO_MBED_P16, IO_REG_OUT_DIR, 2);
    mcugear->setWire(IO_MBED_P21, IO_REG_OUT_DIR, 3);
    mcugear->setWire(IO_MBED_P22, IO_REG_OUT_DIR, 4);
}

void setIOBank6(MCUGear *mcugear){
    mcugear->setWire(IO_MBED_P9, IO_REG_IN_DIR, 0);
    mcugear->setWire(IO_MBED_P10, IO_REG_IN_DIR, 1);
    mcugear->setWire(IO_MBED_P16, IO_REG_OUT_DIR, 4);
    mcugear->setWire(IO_MBED_P21, IO_REG_OUT_DIR, 3);
    mcugear->setWire(IO_MBED_P22, IO_REG_OUT_DIR, 2);
}

void setIOBank7(MCUGear *mcugear){
    mcugear->setWire(IO_MBED_P10, IO_REG_IN_DIR, 0);
    mcugear->setWire(IO_MBED_P9, IO_REG_IN_DIR, 1);
    mcugear->setWire(IO_MBED_P16, IO_REG_OUT_DIR, 2);
    mcugear->setWire(IO_MBED_P21, IO_REG_OUT_DIR, 3);
    mcugear->setWire(IO_MBED_P22, IO_REG_OUT_DIR, 4);
}
