
#include "mbed.h"
#include "TextLCD.h"

#include "MCUGearBaseALPC1114.h"
#include "MCUGearALPC1114.h"
#include "commonALPC1114.h"

Serial pc(dp16, dp15); // tx, rx Set BaudRate = 115200 in main()

void setIOUni(MCUGear *mcugear);
void setIOLCD(MCUGear *mcugear);

MCUGear UniM(dp5, dp27, N_VDD_VDD_VDD);       //2 Connector Universal Module
MCUGear LCDM(dp5, dp27, N_VDD_VSS_VSS);        //LCD Module

//output pins = P0_3, P0_7, P0_11, P1_0, P1_1, P1_2, P1_4, P1_5
DigitalOut Dout1(dp26);
DigitalOut Dout2(dp28);
DigitalOut Dout3(dp4);
DigitalOut Dout4(dp9);
DigitalOut Dout5(dp10);
DigitalOut Dout6(dp11);
DigitalOut Dout7(dp14);
DigitalOut Dout8(dp15);

//inputpins = P1_8, P1_9
DigitalIn Din1(dp17);
DigitalIn Din2(dp18);

int main() {
    
    int sw1 = 0;
    int sw2 = 0;
    pc.printf("Hello World!\r\n");
        
    wait(1);
    
    initBase(); //initialize Baseboard
    
    //set schematic select 0-7
    UniM.detectModule();    //save location data in MCUGear class.
    LCDM.detectModule();    //save location data in MCUGear class.
    
    //startReg(0);  //AutoMode can not use Bank
    setIOUni(&UniM);//make schematic Bank0
    setIOLCD(&LCDM);//make schematic Bank0
    //endReg(0);    //AutoMode can not use Bank
    
    //changeBank(0);//select Bank
    
    
    LCDM.connectModuleA();
    TextLCD lcd(dp26, dp28, dp4, dp9, dp10, dp11, TextLCD::LCD16x2); // rs, e, d4-d7//set output pins from Dout1 to Dout6.
    lcd.cls();
    lcd.printf("Hello World!\n");
    wait(1);
    LCDM.disconnectModule();
    
    while(1) {
        
        UniM.connectModuleA();
        sw1 = Din1.read();
        sw2 = Din2.read();
        printf("sw1 = %d  sw2 = %d\r\n",sw1,sw2);
        UniM.disconnectModule();
        
        LCDM.connectModuleA();
        lcd.printf(" ");    //set IO as a neutral position
        lcd.cls();   //clear LCD
        lcd.printf("sw1 = %d\nsw2 = %d",sw1,sw2);   //write LCD data
        wait_ms(10);    //delay for view the LCD
        LCDM.disconnectModule();
        
        UniM.connectModuleA();
        Dout1 = 0;
        Dout2 = 1;
        Dout3 = 1;
        wait(0.3);
        
        Dout1 = 1;
        Dout2 = 0;
        Dout3 = 1;
        wait(0.3);
        
        Dout1 = 1;
        Dout2 = 1;
        Dout3 = 0;
        wait(0.3);
        UniM.disconnectModule();

    }
}


void setIOUni(MCUGear *mcugear){
    mcugear->setWireA(IOin1, IO_REG_IN_DIR, 0);
    mcugear->setWireA(IOin2, IO_REG_IN_DIR, 1);
    mcugear->setWireA(IOout1, IO_REG_OUT_DIR,2);
    mcugear->setWireA(IOout2, IO_REG_OUT_DIR,3);
    mcugear->setWireA(IOout3, IO_REG_OUT_DIR,4);
}

void setIOLCD(MCUGear *mcugear){
    mcugear->setWireA(IOout1, IO_REG_OUT_DIR,0);
    mcugear->setWireA(IOout2, IO_REG_OUT_DIR,1);
    mcugear->setWireA(IOout3, IO_REG_OUT_DIR,2);
    mcugear->setWireA(IOout4, IO_REG_OUT_DIR,3);
    mcugear->setWireA(IOout5, IO_REG_OUT_DIR,4);
    mcugear->setWireA(IOout6, IO_REG_OUT_DIR,5);
}

