/* MCU Gear Library, only for testing MCUGear without any circuit you connected.
 * Copyright (c) 2013, NestEgg Inc., http://www.mcugear.com/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "commonALPC1114.h"


#define FPGA_SYSINFO_0 0x00
#define FPGA_SYSINFO_1 0x04
#define FPGA_ENABLE    0x08
#define FPGA_DETECT    0x14

void fpga_write(int dev_adr,unsigned char adr, unsigned char data);
unsigned char fpga_read(int dev_adr,unsigned char adr);
void initBase(void);
//void startReg(uint8_t bank);
//void endReg(uint8_t bank);
void deleteBank(uint8_t bank);
void changeBank(uint8_t bank);


// FGPGA CPU I/O
typedef enum {

    IOMOSI = 0x80,//P0_9
    IOSCK,//P0_6
    IOMISO,//P0_8
    IOout4,//P1_0
    NC1,//NC1
    IOout5,//P1_1
    IOout2,//P0_7
    IORX,//P1_6
    NC2,//NC2
    IOin2,//P1_9
    IOTX,//P1_7
    IOin1,//P1_8
    IOout7,//P1_5
    IOout8,//P1_4
    IOout6,//P1_2
    IOout3,//P0_11
    IOout1,//P0_3
    IOCS,//P0_2
    IOSDA,//P0_5
    IOSCL//0_4
            
/*  IOP0_9 = 0x80,//P0_9
    IOP0_6,//P0_6
    IOP0_8,//P0_8
    IOP1_0,//P1_0
    NC1,//NC1
    IOP1_1,//P1_1
    IOP0_7,//P0_7
    IOP1_6,//P1_6
    NC2,//NC2
    IOP1_9,//P1_9
    IOP1_7,//P1_7
    IOP1_8,//P1_8
    IOP1_5,//P1_5
    IOP1_4,//P1_4
    IOP1_2,//P1_2
    IOP0_11,//P0_11
    IOP0_3,//P0_3
    IOP0_2,//P0_2
    IOP0_5,//P0_5
    IO0_4//0_4
*/
} en_cpu_io;

// FPGA EXT I/O
typedef enum {
  IO_CON1_1 = 0,
  IO_CON1_2,
  IO_CON1_3,
  IO_CON1_4,
  IO_CON2_1,
  IO_CON2_2,
  IO_CON2_3,
  IO_CON2_4,
  IO_CON3_1,
  IO_CON3_2,
  IO_CON3_3,
  IO_CON3_4,
  IO_CON4_1,
  IO_CON4_2,
  IO_CON4_3,
  IO_CON4_4,
  IO_CON5_1,
  IO_CON5_2,
  IO_CON5_3,
  IO_CON5_4,
  IO_CON6_1,
  IO_CON6_2,
  IO_CON6_3,
  IO_CON6_4,
  IO_CON7_1,
  IO_CON7_2,
  IO_CON7_3,
  IO_CON7_4,
  IO_CON8_1,
  IO_CON8_2,
  IO_CON8_3,
  IO_CON8_4,
  IO_CON9_1,
  IO_CON9_2,
  IO_CON9_3,
  IO_CON9_4,
  IO_CON10_1,
  IO_CON10_2,
  IO_CON10_3,
  IO_CON10_4,
  IO_CON11_1,
  IO_CON11_2,
  IO_CON11_3,
  IO_CON11_4,
  IO_CON12_1,
  IO_CON12_2,
  IO_CON12_3,
  IO_CON12_4
} en_fpga_io;

typedef enum {
  IO_REG_EN = 0x80,
  IO_REG_OUT_DIR = 0x40,
  IO_REG_IN_DIR  = 0x00,
  IO_REG_DISABLE = 0x3f
} en_fpga_io_reg;


