/* MCU Gear Library, only for testing MCUGear without any circuit you connected.
 * Copyright (c) 2013, NestEgg Inc., http://www.mcugear.com/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


#include "mbed.h"
#include "MCUGearALPC1114.h"
#include "MCUGearBaseALPC1114.h"

MCUGear::MCUGear(PinName scl, PinName sda, char addr)
     : _i2c(scl, sda) {
    _i2c.frequency(FPGA_I2C_CLOCK);
    _addr = addr;   //save address
    write(0xff);    //close Module gate
    _counter = 0;
}

void MCUGear::disconnectModule(void){
    write(0xff);    //close module gate
    deleteBank(0);
}

void MCUGear::connectModuleA(void){
    int i = 0;
    
    //make circuit
    if(_counter!=0){
        
        startReg(0);
        
        for(i = 0; i < _counter; ++i){
          fpga_write(_mcuIO[i], _moduleIO[i]);
        }
        
        endReg();
        
        changeBank(0);
    }
    
    write(0xf8);    //1111 1000
}

void MCUGear::fpga_write(unsigned char adr, unsigned char data) {
  char cmd[2];
  cmd[0] = adr;
  cmd[1] = data;
  _i2c.write(FPGA_I2C_ADR, cmd, 2);
}

void MCUGear::startReg(char bank){
    _bank = bank;
    fpga_write(0x0c,_bank); //End regist
}

uint8_t MCUGear::setWireA(uint8_t mcuIO, uint8_t direction, uint8_t moduleIO){
    
    uint8_t location = ( _pnum + moduleIO );
    
    if(moduleIO >= numMaxModuleIO){
        return 255; //error
    }
    
    if(location >= numBaseboardIO){
        location = location - numBaseboardIO;
    }
    
    //fpga_write(mcuIO, (IO_REG_EN | (direction | (location))));
    saveWire(mcuIO, (IO_REG_EN | (direction | (location))));
    
    return location;
}

void MCUGear::saveWire(uint8_t mcuIO, uint8_t moduleIO){
        _mcuIO[_counter] = mcuIO;
        _moduleIO[_counter] = moduleIO;
        ++_counter;
}

void MCUGear::endReg(void){
    fpga_write(0x10,_bank);//init regist///////
}

void MCUGear::clear(void){
    _counter = 0;
}

//send I2C signal function
void MCUGear::write(uint8_t c){

    char cmd[1];
    cmd[0] = c;
    _i2c.write(_addr, cmd, 1);
    
}

////detect module
uint8_t MCUGear::detectModule(void) {
    
    write(0x7f);   //0111 1111  //1pin GND
    _pnum = fpga_read(FPGA_I2C_ADR,FPGA_DETECT);//save location
    write(0xff);    //1111 1111 //close
    
    _counter = 0;
    
    return _pnum;

}

