
#include "mbed.h"
#include "MCUGearALPC1114.h"
#include "MCUGearBaseALPC1114.h"
#include "AD8chModuleLPC1114.h"

AD8chModule::AD8chModule(SPI _spi, PinName _cs, MCUGear *mcugear)
    :spi(_spi),cs(_cs) {
        
    //miso,mosi,sck,cs
    mcugear->setWireA(IOMISO, IO_REG_IN_DIR, 0);
    mcugear->setWireA(IOMOSI, IO_REG_OUT_DIR, 1);
    mcugear->setWireA(IOSCK, IO_REG_OUT_DIR,2);
    mcugear->setWireA(IOCS, IO_REG_OUT_DIR,3);
}


void AD8chModule::initAD8ch(MCUGear *mcugear){
       cs = 1;
       spi.frequency(2000000); //1MHz
}

int AD8chModule::readADm(MCUGear *mcugear, char ch){

    char sendData;
    int whoami[3];
    char sendData2;
    
    //0000 0000 0110 00 00 [0000 0000 0000]
    
    if(ch < 8){
        sendData = 0x18+ch; //0001 1000
        sendData2 = sendData >> 2;
        sendData = sendData << 6;
        
    }else{
        return -1;
    }
    
    //12bit AD Mobdule----------------
    //mcugear->connectModule();   //connect---
    cs = 0;
    spi.write(sendData2);
    whoami[2] = spi.write(sendData);
    whoami[0] = whoami[2]<<8;
    whoami[0] = whoami[0] + spi.write(0x00)-0xE000;   //get data from AD device
    cs = 1;
    //mcugear->disconnectModule();   //disconnect---
    return whoami[0];
    
}

int AD8chModule::readADa(MCUGear *mcugear, char ch){

    char sendData;
    int whoami[3];
    char sendData2;
    
    //0000 0000 0110 00 00 [0000 0000 0000]
    
    if(ch < 8){
        sendData = 0x18+ch; //0001 1000
        sendData2 = sendData >> 2;
        sendData = sendData << 6;
        
    }else{
        return -1;
    }
    
    //12bit AD Mobdule----------------
    spi.frequency(2000000); //1MHz
    cs = 1; //reset CS pin
    mcugear->connectModuleA();   //connect---
    cs = 0;
    spi.write(sendData2);
    whoami[2] = spi.write(sendData);
    whoami[0] = whoami[2]<<8;
    whoami[0] = whoami[0] + spi.write(0x00)-0xE000;   //get data from AD device
    cs = 1;
    mcugear->disconnectModule();   //disconnect---
    return whoami[0];
    
}
