
#include "mbed.h"
#include "MCUGearALPC1114.h"
#include "MCUGearBaseALPC1114.h"
#include "AD2chModuleLPC1114.h"

AD2chModule::AD2chModule(SPI _spi, PinName _cs, MCUGear *mcugear)
    :spi(_spi),cs(_cs) {
        
    //miso,mosi,sck,cs
    mcugear->setWireA(IOMISO, IO_REG_IN_DIR, 0);
    mcugear->setWireA(IOMOSI, IO_REG_OUT_DIR, 1);
    mcugear->setWireA(IOSCK, IO_REG_OUT_DIR,2);
    mcugear->setWireA(IOCS, IO_REG_OUT_DIR,3);
}


void AD2chModule::initAD2ch(MCUGear *mcugear){
    
       cs = 1;
       
       //12bit SPI DA module----------------
       spi.frequency(2000000); //1MHz
}

int AD2chModule::readADm(MCUGear *mcugear, char ch){

    char sendData;
    int whoami[3];
    
//    spi.frequency(2000000); //1MHz
    if(ch == 0){
        sendData = 0x80;
    }else if(ch == 1){
        sendData = 0xC0;
    }else{
        return -1;
    }
    
    //12bit AD Mobdule----------------
    //cs = 1; //reset CS pin
//    mcugear->connectModule();   //connect---
    
    cs = 0; 
    //FRDM KL25Z is 8-bit format.
    whoami[2] = spi.write(0x01);//0000 0001
    whoami[2] = spi.write(sendData);
    whoami[0] = whoami[2]<<8;
    whoami[0] = whoami[0] + spi.write(0x00) - 0xE000;//0000 0000
//    whoami[2] = 0;//clear buffer
    cs = 1;
//    mcugear->disconnectModule();   //disconnect---
    return whoami[0];
    
}

int AD2chModule::readADa(MCUGear *mcugear, char ch){

    char sendData;
    int whoami[3];
    
    spi.frequency(2000000); //1MHz
    if(ch == 0){
        sendData = 0x80;
    }else if(ch == 1){
        sendData = 0xC0;
    }else{
        return -1;
    }
    
    //12bit AD Mobdule----------------
    cs = 1; //reset CS pin
    mcugear->connectModuleA();   //connect---
    
    cs = 0; 
    //FRDM KL25Z is 8-bit format.
    whoami[2] = spi.write(0x01);//0000 0001
    whoami[2] = spi.write(sendData);
    whoami[0] = whoami[2]<<8;
    whoami[0] = whoami[0] + spi.write(0x00) - 0xE000;//0000 0000
//    whoami[2] = 0;//clear buffer
    cs = 1;
    mcugear->disconnectModule();   //disconnect---
    return whoami[0];
    
}
