/* MCU Gear Library, only for testing MCUGear without any circuit you connected.
 * Copyright (c) 2013, NestEgg Inc., http://www.mcugear.com/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "commonA.h"

class MCUGear
{        
    public:
        MCUGear(PinName sda, PinName scl, char addr);
        void disconnectModule(void);
        void connectModuleA(void);
        void savePinSetting(uint8_t number, unsigned char CPUPin, unsigned char Direction ,unsigned char ModulePin);
        uint8_t detectModule(void);
        //void startReg(char bank);
        uint8_t setWireA(uint8_t mcuIO, uint8_t direction, uint8_t moduleIO);
        //void endReg(char bank);
        
    protected:
        void fpga_write(unsigned char adr, unsigned char data);
        void write(uint8_t c);
        void startReg(char bank);
        void endReg(void);
        void saveWire(uint8_t mcuIO, uint8_t moduleIO);
        
        uint8_t _addr;
        uint8_t _pnum;
        I2C _i2c;
        char _bank;
        uint8_t _mcuIO[16];
        uint8_t _moduleIO[16];
        int _counter;
                
        typedef enum {
          IO_REG_EN = 0x80,
          IO_REG_OUT_DIR = 0x40,
          IO_REG_IN_DIR  = 0x00,
          IO_REG_DISABLE = 0x3f
        } en_fpga_io_reg;

};



