/* MCU Gear Library, only for testing MCUGear without any circuit you connected.
 * Copyright (c) 2013, NestEgg Inc., http://www.mcugear.com/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"
#include "MCUGearBaseA.h"

#if defined TARGET_LPC1768
I2C fpga_i2c(p28, p27);
#endif

#if defined TARGET_KL25Z
I2C fpga_i2c(PTE0, PTE1);
#endif

void fpga_write(int dev_adr,unsigned char adr, unsigned char data) {
  char cmd[2];
  cmd[0] = adr;
  cmd[1] = data;
  fpga_i2c.frequency (FPGA_I2C_CLOCK);
  fpga_i2c.write(dev_adr, cmd, 2);

}

unsigned char fpga_read(int dev_adr,unsigned char adr) {
  char cmd[2];
  cmd[0] = adr;
  fpga_i2c.write(dev_adr, cmd, 1);
  fpga_i2c.read(dev_adr, cmd, 1);
  return cmd[0];
}

void initBase(void){

    // FPGA reg clear
     for (int i=0;i<20;i++)
       fpga_write(FPGA_I2C_ADR,0x80+i,0);
     
    // read FPGA registers
    fpga_read(FPGA_I2C_ADR,FPGA_SYSINFO_0);
    fpga_read(FPGA_I2C_ADR,FPGA_SYSINFO_0+1);
    fpga_read(FPGA_I2C_ADR,FPGA_SYSINFO_0+2);
    fpga_read(FPGA_I2C_ADR,FPGA_SYSINFO_0+3);
    // FPGA enable
    fpga_write(FPGA_I2C_ADR,FPGA_ENABLE,1);   
}

void I2Cwrite(char addr, char data){

    char cmd[1];
    cmd[0] = data;
    fpga_i2c.write(addr, cmd, 1);
    //wait(0.01);
    
}

void changeBank(uint8_t bank){
    fpga_write(FPGA_I2C_ADR,0x10,bank);
}

void deleteBank(uint8_t bank){
    fpga_write(FPGA_I2C_ADR,0x0c,(bank|0x80));
    fpga_write(FPGA_I2C_ADR,0x10, bank);
}
/*
void startReg(uint8_t bank){
    fpga_write(FPGA_I2C_ADR,0x0c,bank);
}

void endReg(uint8_t bank){
    fpga_write(FPGA_I2C_ADR,0x10, (bank|0x04));
}
*/


