/* MCU Gear Library, only for testing MCUGear without any circuit you connected.
 * Copyright (c) 2013, NestEgg Inc., http://www.mcugear.com/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


#include "mbed.h"
#include "MCUGear.h"
#include "MCUGearBase.h"

#ifdef DEBUG
Serial MCUGear_pc(USBTX, USBRX); // tx, rx
#endif


unsigned char Layer[12];
unsigned char BankSetting[12][32];
unsigned char BankAndInPins[7][20];

unsigned char NowBank;

//init
//#ifdef BANK_MODE
MCUGear::MCUGear(PinName scl, PinName sda, char addr, char NumberOfPin)
     : _i2c(scl, sda) {
    _i2c.frequency(FPGA_I2C_CLOCK);
    _addr = addr;
    data = 0x00;
    flgReg = 0;
    NowBank = 0;
    numPin = NumberOfPin;
//    numCon = ConnectorNumber;
    if(numPin<=4){
        numCon = 1;
    }else if((numPin > 4)&&(numPin <= 8)){
        numCon = 2;
    }else if(numPin > 8){
        numCon = 3;
    }else{
        ;//error
    }
    
    write(0xff);
    
}
/*
#else
MCUGear::MCUGear(PinName scl, PinName sda, char a)
     : _i2c(scl, sda) {
    _i2c.frequency(FPGA_I2C_CLOCK);
    _addr = a;
    Bank = 0;
    data = 0x00;
    flgReg = 0;
}

#endif
*/

//insert data function

void MCUGear::savePinSetting(uint8_t number, unsigned char CPUPin,unsigned char Direction ,unsigned char ModulePin){
    ip[number] = CPUPin;
    op[number] = (Direction|ModulePin);

#ifdef DEBUG
    MCUGear_pc.printf("ModulePin = %x :op[%d] = %x : ip[%d] = %x\n",ModulePin, number, op[number], number, ip[number]);
    wait(0.1);
    //MCUGear_pc.printf("sizeof(ModulePin) = %ubyte\n",sizeof(ModulePin));
    //wait(0.1);
#endif

}
/*
uint8_t MCUGear::disconnectModule(void){

    write(0xff);    //close module gate
    
    if(Bank == 0){
        fpga_write(0x0c,(0|0x80));//regist - Delete all connection on Bank 0.
        wait(0.001);
        fpga_write(0x10, 0);//enable
    }
    
    return 1;
    
}
*/
uint8_t MCUGear::disconnectModule(void){

    write(0xff);    //close module gate

    if(Bank == 0){

//#ifdef test    
        fpga_write(0x0c,(Bank|0x80));//regist - Delete all connection on Bank 0.
        wait(0.001);
        fpga_write(0x10, Bank);//enable
/*#else
        int i=0;
        
        fpga_write(0x0c, 0);//regist
        //Rest all IO connction on Bank 0.
        
        for(i=0; i<16; ++i){
            fpga_write(ip[i], (IO_REG_DISABLE | op[i]));
            wait(0.0001);
        }
        fpga_write(0x10, (Bank|0x40));//enable
        
#endif
*/
    }
    return 1;
    
}

uint8_t MCUGear::connectModule(void){

#ifdef DEBUG
    MCUGear_pc.printf("_addr = %x, [NowBank = %d ,Bank = %d] \n",_addr, NowBank, Bank);
    wait(0.1);
#endif

    int i=0;
    
    if(flgReg==0){
        fpga_write(0x0c,Bank);//init regist
        
    }else{
        if(Bank == NowBank){
            ;   //Nothing to do
#ifdef DEBUG
    MCUGear_pc.printf("_Nothing to do \n");
    wait(0.1);
#endif
        }else{
            fpga_write(0x0c,Bank);//regist
        }
    }
    

    if(Bank != 0){  //Bank is between 1-7
        if(flgReg==0){  //Onetime IO connections
        
            for(i=0; i<16; ++i){
                fpga_write(ip[i], (IO_REG_EN | op[i]));
                wait(0.0001);
                
                if((numCon==1)&&(i==3)){
                    write(0xfe);    //1111 1110
                    break;
                    
                }else if((numCon==2)&&(i==7)){
                    write(0xfc);    //1111 1100
                    break;
                    
                }else if((numCon==3)&&(i==11)){
                    write(0xf8);    //1111 1000
                    break;
                    
                }else if(i > 12){
                    return 2;//error
                }
            }
            
            fpga_write(0x10,Bank);//init regist///////
            flgReg = 1;
        }else{  //only change module gate
        
            if(numCon==1){
                write(0xfe);    //1111 1110
                
            }else if(numCon==2){
                write(0xfc);    //1111 1100
                    
            }else if(numCon==3){
                write(0xf8);    //1111 1000
                    
            }else{
                return 2;//error
            }
        
        }
//#else
    }else{  //You need to change IO connections evrytime on Bank 0.
        for(i=0; i<16; ++i){
            fpga_write(ip[i], (IO_REG_EN | op[i]));
            wait(0.0001);
            
            if((numCon==1)&&(i==3)){
                write(0xfe);    //1111 1110
                break;
                    
            }else if((numCon==2)&&(i==7)){
                write(0xfc);    //1111 1100
                break;
                    
            }else if((numCon==3)&&(i==11)){
                write(0xf8);    //1111 1000
                break;
                    
            }else if(i > 12){
                return 2;//error
            }
        }
        fpga_write(0x10,Bank);//init regist///////
    }
//#endif
/*
    if(flgReg==0){
        flgReg = 1;
        fpga_write(0x10,Bank);//init regist
        
    }else{
        if(Bank == NowBank){
            ;   //Nothing to do
#ifdef DEBUG
    MCUGear_pc.printf("_Nothing to do \n");
    wait(0.1);
#endif
        }else{
            fpga_write(0x10,Bank);//regist
        }
    }
*/
    
    /*
    if((Bank != NowBank)){
        fpga_write(0x10,  Bank);    //Bank enable
    }
    */
    NowBank = Bank; //set NowBank
    
    return 1;
}



void MCUGear::fpga_write(unsigned char adr, unsigned char data) {
  char cmd[2];
  cmd[0] = adr;
  cmd[1] = data;
  _i2c.write(FPGA_I2C_ADR, cmd, 2);
  //wait(0.01);
  //pc.printf("fpga write adr:%x data:%x\n", adr,data);
}


void MCUGear::set_addr(char s){
    _addr = s;
}

void MCUGear::set_data(char c){
    data = c;
}

//send I2C signal function
void MCUGear::write(char c){

    char cmd[1];
    cmd[0] = c;
    _i2c.write(_addr, cmd, 1);
    //wait(0.01);
    
}

////detect module
void MCUGear::detect_module(uint8_t *fio) {
    int i;
  uint8_t pnum=0xff;
  uint8_t iio;
  //1pin GND
  
  write(0x7f);   //0111 1111
  //wait(0.1);
  pnum =fpga_read(FPGA_I2C_ADR,FPGA_DETECT);

#ifdef DEBUG
  wait(1);
    MCUGear_pc.printf("detected. port %d \n",pnum);
  wait(0.1);
#endif
  write(0xff);    //1111 1111

    iio = pnum;
    if(iio != 0xff){
        //Resolve boundary value problem
        pinArrey[0] = iio;
        
        iio = iio + 4;
        
        if((iio > 44)){
            iio = 0;;
        }
        pinArrey[1] = iio;
        
        
        iio = iio + 4;
        
        if((iio > 44)){
            iio = 0;
        }
        pinArrey[2] = iio;
        
#ifdef DEBUG      
        MCUGear_pc.printf("detected. pinArrey[0] = %d \n",pinArrey[0]);
        wait(0.1);
#endif
        
        //makeCircuit();
    }

    for(i=0;i<12;++i){
        if(pnum+i>47){
            fio[i] = pnum+i-48;
        }else{
            fio[i] = pnum+i;
        }
        
  
#ifdef DEBUG      
        //MCUGear_pc.printf("detected. fio[%d] = %d \n",i,fio[i]);
        //wait(0.1);
#endif

    }

 // return pnum;
}



///making onecircuit 
void MCUGear::makeCircuit(void){
    //unsigned char i = 0;
    char i = 0;
    unsigned char j = 0;
    int k = 0;
    unsigned char con = 0;
    unsigned char conNum2 = 0;
    unsigned char MaxLayer = 0;
    
    con = (pinArrey[0]/4)+1;    //creat connector number

#ifdef DEBUG
    MCUGear_pc.printf("makeCircuit con = (pinArrey[%d]/4)+1 = %d \n",i,con);
    wait(0.1);
#endif

    //find MaxLayer
    for(i=0; i<numCon; ++i){
        if((con+i) > 12){
            ++Layer[con + i - 12];
            
            if(MaxLayer < Layer[con + i - 12]){
                MaxLayer = Layer[con + i - 12];
            }
        }else{
            ++Layer[con + i];
            
            if(MaxLayer < Layer[con + i]){
                MaxLayer = Layer[con + i];
            }
        }
    }
    
    //Check over rap CPU pins on a Bank
    //If it find over rap, set other layers.
    conNum2 = numCon * 4;
    
    for(i=0; i<20; ++i){
        for(j=0; j<numPin; ++j){
            if(BankAndInPins[MaxLayer][i] == ip[j]){
                ++MaxLayer;
                
#ifdef DEBUG
    MCUGear_pc.printf("CPU IO over rap! ++MaxLayer : %d \n",MaxLayer);
    wait(0.1);
#endif
                //i = 0x20;
                //j = numPin;
                //break;
                i = 0;
                j = 0;
            }
        }
    }
    
    //Save Datas
    for(j=0; j<conNum2; ++j){
        k = (int)(ip[j]-0x80);
        BankAndInPins[MaxLayer][k] = ip[j];
#ifdef DEBUG
    MCUGear_pc.printf("BankAndInPins[%d][%d] = %x \n",MaxLayer,k,ip[j]);
    wait(0.1);
#endif
    }
    
    
    //save MaxLayer to all connectors
    for(i=0; i<numCon; ++i){
        if(MaxLayer > Layer[con + i]){
            Layer[con + i] = MaxLayer;
        }
        
    }
    
    
#ifdef DEBUG
    MCUGear_pc.printf("MaxLayer = %d \n",MaxLayer);
    wait(0.1);
#endif
    
    for(i=0; i<numCon; ++i){
        
        if((con + i)>12){
            BankSetting[con + i - 12][MaxLayer] = _addr;

#ifdef DEBUG
            MCUGear_pc.printf("BankSetting[CON %d][Layer %d] = %x \n",(con + i - 12),MaxLayer,_addr);
            wait(0.1);
#endif
        }else{
            BankSetting[con + i][MaxLayer] = _addr;

#ifdef DEBUG
            MCUGear_pc.printf("BankSetting[CON %d][Layer %d] = %x \n",(con + i),MaxLayer,_addr);
            wait(0.1);
#endif
        }
    }
    
    
    //make 0-6 BANKs others are chang single pin
    //MaxLayer = BANK No
    
    if(MaxLayer <= BankMaxNum){
        fpga_write(0x0c,  MaxLayer);    //regist to Bank
        Bank = MaxLayer;
    }else{
        Bank = 0;
#ifdef DEBUG
            MCUGear_pc.printf("set Bank = 0\n");
            wait(0.1);
#endif
        
    }
    
}




