/* MCU Gear Library, only for testing MCUGear without any circuit you connected.
 * Copyright (c) 2013, NestEgg Inc., http://www.mcugear.com/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "common.h"


#define FPGA_SYSINFO_0 0x00
#define FPGA_SYSINFO_1 0x04
#define FPGA_ENABLE    0x08
#define FPGA_DETECT    0x14

/*
// cpu port mapping
#define P5 0
//
#define CON1_1 0
#define CON1_2 0
#define CON1_3 0
#define CON1_4 0
*/
void fpga_write(int dev_adr,unsigned char adr, unsigned char data);
unsigned char fpga_read(int dev_adr,unsigned char adr);
void initBase(void);
int detect_module(char addr);


// FGPGA CPU I/O
typedef enum {

#ifdef LPC1768_mbed
  IO_MBED_P15 = 0x80,
  IO_MBED_P13,
  IO_MBED_P16,
  IO_MBED_P12,
  IO_MBED_P5,
  IO_MBED_P11,
  IO_MBED_P23,
  IO_MBED_P22,
  IO_MBED_P26,
  IO_MBED_P10,
  IO_MBED_P21,
  IO_MBED_P9,
  IO_MBED_P6,
  IO_MBED_P7,
  IO_MBED_P8,
  IO_MBED_P14,
  IO_MBED_P24,
  IO_MBED_P25,
  IO_MBED_P28,
  IO_MBED_P27
#endif

#ifdef FS_KL25Z

  IO_MBED_PTA5 = 0x80,
  IO_MBED_PTC8,
  IO_MBED_PTC9,
  IO_MBED_PTD5,
  IO_MBED_PTA13,
  IO_MBED_PTD2,
  IO_MBED_PTB1,
  IO_MBED_PTB2,
  IO_MBED_PTA2,
  IO_MBED_PTD4,
  IO_MBED_PTB3,
  IO_MBED_PTA12,
  IO_MBED_PTD0,
  IO_MBED_PTD3,
  IO_MBED_PTD1,
  IO_MBED_PTA4,
  IO_MBED_PTB0,
  IO_MBED_PTA1,
  IO_MBED_PTE0, //SDA
  IO_MBED_PTE1  //SCL
#endif
  
} en_cpu_io;

// FPGA EXT I/O
typedef enum {
  IO_CON1_1 = 0,
  IO_CON1_2,
  IO_CON1_3,
  IO_CON1_4,
  IO_CON2_1,
  IO_CON2_2,
  IO_CON2_3,
  IO_CON2_4,
  IO_CON3_1,
  IO_CON3_2,
  IO_CON3_3,
  IO_CON3_4,
  IO_CON4_1,
  IO_CON4_2,
  IO_CON4_3,
  IO_CON4_4,
  IO_CON5_1,
  IO_CON5_2,
  IO_CON5_3,
  IO_CON5_4,
  IO_CON6_1,
  IO_CON6_2,
  IO_CON6_3,
  IO_CON6_4,
  IO_CON7_1,
  IO_CON7_2,
  IO_CON7_3,
  IO_CON7_4,
  IO_CON8_1,
  IO_CON8_2,
  IO_CON8_3,
  IO_CON8_4,
  IO_CON9_1,
  IO_CON9_2,
  IO_CON9_3,
  IO_CON9_4,
  IO_CON10_1,
  IO_CON10_2,
  IO_CON10_3,
  IO_CON10_4,
  IO_CON11_1,
  IO_CON11_2,
  IO_CON11_3,
  IO_CON11_4,
  IO_CON12_1,
  IO_CON12_2,
  IO_CON12_3,
  IO_CON12_4
} en_fpga_io;

typedef enum {
  IO_REG_EN = 0x80,
  IO_REG_OUT_DIR = 0x40,
  IO_REG_IN_DIR  = 0x00,
  IO_REG_DISABLE = 0x3f
} en_fpga_io_reg;


