/* MCU Gear Library, only for testing MCUGear without any circuit you connected.
 * Copyright (c) 2013, NestEgg Inc., http://www.mcugear.com/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "common.h"

class MCUGear
{        
    public:
//#ifdef BANK_MODE
        MCUGear(PinName sda, PinName scl, char addr, char NumberOfPin);
//#else
//        MCUGear(PinName sda, PinName scl, char a);
//#endif
        void set_addr(char s);
        void set_data(char c);
        void write(char c);
        char data;
        char _addr;
        void savePinSetting(uint8_t number, unsigned char CPUPin, unsigned char Direction ,unsigned char ModulePin);
        uint8_t connectModule(void);
        uint8_t disconnectModule(void);
        void fpga_write(unsigned char adr, unsigned char data);
        void detect_module(uint8_t *fio);
        void makeCircuit(void);
        
    protected:
        I2C _i2c;
        char Bank;
        char flgReg;
        char numPin;
        char numCon;
        unsigned char pinArrey[3];
        
        uint8_t ip[12];
        uint8_t op[12];
                
        typedef enum {
          IO_REG_EN = 0x80,
          IO_REG_OUT_DIR = 0x40,
          IO_REG_IN_DIR  = 0x00,
          IO_REG_DISABLE = 0x3f
        } en_fpga_io_reg;

};



