/* MCU Gear Library, only for testing MCUGear without any circuit you connected.
 * Copyright (c) 2013, NestEgg Inc., http://www.mcugear.com/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


//select your mbed--------------------------------------------
#define LPC1768_mbed
//#define FS_KL25Z

//#define BOOST_MODE //if you want use BANK System, define this.
//------------------------------------------------------------

//For Sample Mltifunction Mofdule-----------------------------
//#define AD_MODE
//#define PWM_MODE
//#define I2C_MODE

//------------------------------------------------------------




//#define DEBUG //If you need to debug, define this.
#ifdef LPC1768_mbed

#define BaudRate 9600
#define FPGA_I2C_CLOCK    1000000
#define MODULE_I2C_CLOCK    1000000

#endif

#ifdef FS_KL25Z

#define BaudRate 19200
#define FPGA_I2C_CLOCK    2000000   //about 769kHz
#define MODULE_I2C_CLOCK    2000000

#endif


#define FPGA_I2C_ADR 0x78

#ifdef DEBUG
#define BankMaxNum 3 //you can set 1 to 7 BANKs for Debug Mode.

#else
#define BankMaxNum 7 //BANK layers

#endif

//PCA9674
            //VSS = GND VDD = +3.3V
            //AD2 AD1 AD0
#define    N_VSS_SCL_VSS    0x20
#define    N_VSS_SCL_VDD    0x22
#define    N_VSS_SDA_VSS    0x24
#define    N_VSS_SDA_VDD    0x26
#define    N_VDD_SCL_VSS    0x28
#define    N_VDD_SCL_VDD    0x2A
#define    N_VDD_SDA_VSS    0x2C
#define    N_VDD_SDA_VDD    0x2E
#define    N_VSS_SCL_SCL    0x30
#define    N_VSS_SCL_SDA    0x32
#define    N_VSS_SDA_SCL    0x34
#define    N_VSS_SDA_SDA    0x36
#define    N_VDD_SCL_SCL    0x38
#define    N_VDD_SCL_SDA    0x3A
#define    N_VDD_SDA_SCL    0x3C
#define    N_VDD_SDA_SDA    0x3E
#define    N_VSS_VSS_VSS    0x40
#define    N_VSS_VSS_VDD    0x42
#define    N_VSS_VDD_VSS    0x44
#define    N_VSS_VDD_VDD    0x46
#define    N_VDD_VSS_VSS    0x48
#define    N_VDD_VSS_VDD    0x4A
#define    N_VDD_VDD_VSS    0x4C
#define    N_VDD_VDD_VDD    0x4E
#define    N_VSS_VSS_SCL    0x50
#define    N_VSS_VSS_SDA    0x52
#define    N_VSS_VDD_SCL    0x54
#define    N_VSS_VDD_SDA    0x56
#define    N_VDD_VSS_SCL    0x58
#define    N_VDD_VSS_SDA    0x5A
#define    N_VDD_VDD_SCL    0x5C
#define    N_VDD_VDD_SDA    0x5E
#define    N_SCL_SCL_VSS    0xA0
#define    N_SCL_SCL_VDD    0xA2
#define    N_SCL_SDA_VSS    0xA4
#define    N_SCL_SDA_VDD    0xA6
#define    N_SDA_SCL_VSS    0xA8
#define    N_SDA_SCL_VDD    0xAA
#define    N_SDA_SDA_VSS    0xAC
#define    N_SDA_SDA_VDD    0xAE
#define    N_SCL_SCL_SCL    0xB0
#define    N_SCL_SCL_SDA    0xB2
#define    N_SCL_SDA_SCL    0xB4
#define    N_SCL_SDA_SDA    0xB6
#define    N_SDA_SCL_SCL    0xB8
#define    N_SDA_SCL_SDA    0xBA
#define    N_SDA_SDA_SCL    0xBC
#define    N_SDA_SDA_SDA    0xBE
#define    N_SCL_VSS_VSS    0xC0
#define    N_SCL_VSS_VDD    0xC2
#define    N_SCL_VDD_VSS    0xC4
#define    N_SCL_VDD_VDD    0xC6
#define    N_SDA_VSS_VSS    0xC8
#define    N_SDA_VSS_VDD    0xCA
#define    N_SDA_VDD_VSS    0xCC
#define    N_SDA_VDD_VDD    0xCE
#define    N_SCL_VSS_SCL    0xE0
#define    N_SCL_VSS_SDA    0xE2
#define    N_SCL_VDD_SCL    0xE4
#define    N_SCL_VDD_SDA    0xE6
#define    N_SDA_VSS_SCL    0xE8
#define    N_SDA_VSS_SDA    0xEA
#define    N_SDA_VDD_SCL    0xEC
#define    N_SDA_VDD_SDA    0xEE


//PCA9674A
    //VSS = GND VDD = +3.3V
    //AD2 AD1 AD0
#define    A_VSS_SCL_VSS    0x10
#define    A_VSS_SCL_VDD    0x12
#define    A_VSS_SDA_VSS    0x14
#define    A_VSS_SDA_VDD    0x16
#define    A_VDD_SCL_VSS    0x18
#define    A_VDD_SCL_VDD    0x1A
#define    A_VDD_SDA_VSS    0x1C
#define    A_VDD_SDA_VDD    0x1E
#define    A_VSS_SCL_SCL    0x60
#define    A_VSS_SCL_SDA    0x62
#define    A_VSS_SDA_SCL    0x64
#define    A_VSS_SDA_SDA    0x66
#define    A_VDD_SCL_SCL    0x68
#define    A_VDD_SCL_SDA    0x6A
#define    A_VDD_SDA_SCL    0x6C
#define    A_VDD_SDA_SDA    0x6E
#define    A_VSS_VSS_VSS    0x70
#define    A_VSS_VSS_VDD    0x72
#define    A_VSS_VDD_VSS    0x74
#define    A_VSS_VDD_VDD    0x76
//#define    A_VDD_VSS_VSS    0x78 //This is baseboard address. It is reserved.
#define    A_VDD_VSS_VDD    0x7A
#define    A_VDD_VDD_VSS    0x7C
#define    A_VDD_VDD_VDD    0x7E
#define    A_VSS_VSS_SCL    0x80
#define    A_VSS_VSS_SDA    0x82
#define    A_VSS_VDD_SCL    0x84
#define    A_VSS_VDD_SDA    0x86
#define    A_VDD_VSS_SCL    0x88
#define    A_VDD_VSS_SDA    0x8A
#define    A_VDD_VDD_SCL    0x8C
#define    A_VDD_VDD_SDA    0x8E
#define    A_SCL_SCL_VSS    0x90
#define    A_SCL_SCL_VDD    0x92
#define    A_SCL_SDA_VSS    0x94
#define    A_SCL_SDA_VDD    0x96
#define    A_SDA_SCL_VSS    0x98
#define    A_SDA_SCL_VDD    0x9A
#define    A_SDA_SDA_VSS    0x9C
#define    A_SDA_SDA_VDD    0x9E
#define    A_SCL_SCL_SCL    0xD0
#define    A_SCL_SCL_SDA    0xD2
#define    A_SCL_SDA_SCL    0xD4
#define    A_SCL_SDA_SDA    0xD6
#define    A_SDA_SCL_SCL    0xD8
#define    A_SDA_SCL_SDA    0xDA
#define    A_SDA_SDA_SCL    0xDC
#define    A_SDA_SDA_SDA    0xDE
#define    A_SCL_VSS_VSS    0xF0
#define    A_SCL_VSS_VDD    0xF2
#define    A_SCL_VDD_VSS    0xF4
#define    A_SCL_VDD_VDD    0xF6
#define    A_SDA_VSS_VSS    0xF8
#define    A_SDA_VSS_VDD    0xFA
#define    A_SDA_VDD_VSS    0xFC
#define    A_SDA_VDD_VDD    0xFE
#define    A_SCL_VSS_SCL    0x00
#define    A_SCL_VSS_SDA    0x02
#define    A_SCL_VDD_SCL    0x04
#define    A_SCL_VDD_SDA    0x06
#define    A_SDA_VSS_SCL    0x08
#define    A_SDA_VSS_SDA    0x0A
#define    A_SDA_VDD_SCL    0x0C
#define    A_SDA_VDD_SDA    0x0E


