/* MCU Gear Library, only for testing MCUGear without any circuit you connected.
 * Copyright (c) 2013, NestEgg Inc., http://www.mcugear.com/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"
#include "MCUGearBase.h"

#ifdef LPC1768_mbed
I2C fpga_i2c(p28, p27);
#endif

#ifdef FS_KL25Z
I2C fpga_i2c(PTE0, PTE1);
#endif




#ifdef DEBUG
Serial fpga_pc(USBTX, USBRX); // tx, rx
#endif

void fpga_write(int dev_adr,unsigned char adr, unsigned char data) {
  char cmd[2];
  cmd[0] = adr;
  cmd[1] = data;
  fpga_i2c.frequency (FPGA_I2C_CLOCK);
  fpga_i2c.write(dev_adr, cmd, 2);
  //wait(0.01);
  
#ifdef DEBUG
  fpga_pc.printf("fpga write adr:%x data:%x\n", adr,data);
#endif

}

unsigned char fpga_read(int dev_adr,unsigned char adr) {
  char cmd[2];
  cmd[0] = adr;
  fpga_i2c.write(dev_adr, cmd, 1);
  //wait(0.01);
  fpga_i2c.read(dev_adr, cmd, 1);
  //wait(0.01);
  //pc.printf("fpga read adr:%x data:%x\n", adr,cmd[0]);
  return cmd[0];
}

void initBase(void){

#ifdef DEBUG
    fpga_pc.baud(BaudRate);
#endif

    // FPGA reg clear
     for (int i=0;i<20;i++)
       fpga_write(FPGA_I2C_ADR,0x80+i,0);
     
    // read FPGA registers

#ifdef DEBUG
    fpga_pc.printf("I2C test\n");
#endif
    fpga_read(FPGA_I2C_ADR,FPGA_SYSINFO_0);
    fpga_read(FPGA_I2C_ADR,FPGA_SYSINFO_0+1);
    fpga_read(FPGA_I2C_ADR,FPGA_SYSINFO_0+2);
    fpga_read(FPGA_I2C_ADR,FPGA_SYSINFO_0+3);
    // FPGA enable
    fpga_write(FPGA_I2C_ADR,FPGA_ENABLE,1);
    
}


void I2Cwrite(char addr, char data){

    char cmd[1];
    cmd[0] = data;
    fpga_i2c.write(addr, cmd, 1);
    //wait(0.01);
    
}

int detect_module(char addr) {
  int pnum=0xff;
  //1pin GND
  I2Cwrite(addr,0x7f);    //0111 1111
  //wait(0.1);
  pnum =fpga_read(FPGA_I2C_ADR,FPGA_DETECT);
  wait(1);
#ifdef DEBUG
  fpga_pc.printf("detected. port %d \n",pnum);
#endif
  I2Cwrite(addr,0xff);    //1111 1111
  //wait(0.1);
  return pnum;
}




