
#include "mbed.h"
#include "MCUGearALPC1114.h"
#include "MCUGearBaseALPC1114.h"
#include "DAmoduleLPC1114.h"

DAmodule::DAmodule(SPI _spi, PinName _cs, PinName _dout1, MCUGear *mcugear)
    :spi(_spi),cs(_cs), dout1(_dout1) {
        
    //Dout,mosi,sck,cs
    mcugear->setWireA(IOout1, IO_REG_OUT_DIR, 0);
    mcugear->setWireA(IOMOSI, IO_REG_OUT_DIR, 1);
    mcugear->setWireA(IOSCK, IO_REG_OUT_DIR,2);
    mcugear->setWireA(IOCS, IO_REG_OUT_DIR,3);
}


void DAmodule::initDA(MCUGear *mcugear){
    
       cs = 1;
       dout1=1;    //reset ratch signal
       
       //12bit SPI DA module----------------
       spi.frequency(20000000); //10MHz
}

void DAmodule::writeDAm(MCUGear *mcugear, int data){

       //12bit SPI DA module----------------
       //DA signl uses the data of AD 0ch. 
       //cs = 1;
       //dout1=1;    //reset ratch signal
       
       //12bit SPI DA module----------------
       //spi.frequency(20000000); //10MHz
       //connection
       //mcugear->connectModuleA();   //connect---
       cs = 0;
       spi.write((0x30)+((data>>8)&0x0F));//write 0011 0000
       spi.write(data&0xFF);//write 0011 1000 0000 0000

       wait_us(1);  //over 15nsec
       cs = 1;      //CS high
       wait_us(1);  //over 40nsec
       dout1=0;      //ratch for DA out enable
       wait_us(1);  //over 100nsec
       dout1=1;      //reset ratch signal
       //mcugear->disconnectModule();   //disconnect---
       //wait_us(1);  //wait after disconnect
}

void DAmodule::writeDAa(MCUGear *mcugear, int data){

       //12bit SPI DA module----------------
       //DA signl uses the data of AD 0ch. 
       cs = 1;
       dout1=1;    //reset ratch signal
       
       //12bit SPI DA module----------------
       spi.frequency(20000000); //10MHz
       //connection
       mcugear->connectModuleA();   //connect---
       cs = 0;
       spi.write((0x30)+((data>>8)&0x0F));//write 0011 0000
       spi.write(data&0xFF);//write 0011 1000 0000 0000

       wait_us(1);  //over 15nsec
       cs = 1;      //CS high
       wait_us(1);  //over 40nsec
       dout1=0;      //ratch for DA out enable
       wait_us(1);  //over 100nsec
       dout1=1;      //reset ratch signal
       mcugear->disconnectModule();   //disconnect---
}
