/*
##############################################
##    Program Created by Harshavardan61     ##
##############################################
        ---- harshavardan61@gmail.com -----
        
Extended by Jason Brewer 2015

*/

#include "lsMotor.h"
#include "mbed.h"

lsMotor::lsMotor(PinName A0, PinName A1, PinName A2, PinName A3, PinName motorEnable, const int maxSteps) : _A0(A0), _A1(A1), 
                        _A2(A2), _A3(A3), _motorEnable(motorEnable) { 
    _A0=0;
    _A1=0;
    _A2=0;
    _A3=0;
    _motorEnable = 0;
    _maxSteps = maxSteps;
    _motorPosition = maxSteps;
}

//UP
void lsMotor::up(int num_steps) { // rotate the motor num_steps UP
    short subStep = 0;
    //printf("In UP\n");
    for (int i = 0; i < num_steps && _motorPosition < _maxSteps; i++) { 
        //printf("numsteps: %d Doing UP %d pos: %d\n", num_steps, i, _motorPosition);               
        switch (subStep) { // activate the ports A0, A2, A3, A3 in a binary sequence for steps
            case 0: {
                _A0=1;
                _A1=0;
                _A2=0;
                _A3=1;
            }
            break;
            case 1: {
                _A0=0;
                _A1=0;
                _A2=1;
                _A3=1;
            }
            break;
            case 2: {
                _A0=0;
                _A1=1;
                _A2=1;
                _A3=0;
            }
            break;
            case 3: {
                _A0=1;
                _A1=1;
                _A2=0;
                _A3=0;
            }
            break;            
        }

        subStep++;
        subStep %= 4;        
        _motorPosition++;
        wait_ms(_motorSpeed);
    }
    /*_A0=0;
    _A1=0;
    _A2=0;
    _A3=0;*/
    return;
}

// DOWN
void lsMotor::down(int num_steps) { // rotate the motor num_steps DOWN
    short subStep = 0;   
    //printf("In DOWN\n"); 
    for (int i = 0; i < num_steps && _motorPosition > 0; i++) { 
        //printf("numsteps: %d Doing DOWN %d pos: %d\n", num_steps, i, _motorPosition);           
        switch (subStep) {
            case 0: {
                _A0=1;
                _A1=1;
                _A2=0;
                _A3=0;
            }
            break;
            case 1: {
                _A0=0;
                _A1=1;
                _A2=1;
                _A3=0;
            }
            break;
            case 2: {
                _A0=0;
                _A1=0;
                _A2=1;
                _A3=1;
            }
            break;
            case 3: {
                _A0=1;
                _A1=0;
                _A2=0;
                _A3=1;
            }
            break;            
        }
    
        subStep++;
        subStep %= 4;
        _motorPosition--;
        wait_ms(_motorSpeed); // wait time defines the speed 
    }
    /*_A0=0;
    _A1=0;
    _A2=0;
    _A3=0;*/
    return;
}

void lsMotor::setMotorPosition(int position) {
    _motorPosition = position;
    return;
}

void lsMotor::step(int num_steps, int direction, int speed) {// steper function: number of steps, direction (0- down, 1- up), speed in ms
    _motorSpeed = speed; //set motor speed
    if (!direction){ // shaft DOWN
            _motorEnable = 1;
            down(num_steps);
            _motorEnable = 0;
    }else if (direction){// Shaft UP
            _motorEnable = 1;
            up(num_steps);
            _motorEnable = 0; 
    }
}