/*
##############################################
##Original Program Created by Harshavardan61##
##############################################
        ---- harshavardan61@gmail.com -----
Extended by Jason Brewer 2015
to adapt to the stepper motor + linear actuator
supplied by Selim Yilmaz

Now includes functional stepper pulses, a motor enable pin
(motor and l293D were getting very warm if the enable pin was
always HIGH)

*/
#ifndef MBED_LSMOTOR_H
#define MBED_LSMOTOR_H

#include "mbed.h"

class lsMotor {
public:

    lsMotor(PinName A0, PinName A1, PinName A2, PinName A3, PinName motorEnable, const int maxSteps); //motor constructor

    void setMotorPosition(int position); // for use ONLY if the stepper init is skipped
    int getMotorPosition(void){ return _motorPosition; }; 
    void step(int num_steps, int direction, int speed);
    void up(int num_steps);
    void down(int num_steps);


private:

    DigitalOut _A0;
    DigitalOut _A1;
    DigitalOut _A2;
    DigitalOut _A3;
    DigitalOut _motorEnable;
    int _motorPosition;
    int _maxSteps;
    int _motorSpeed; 

};

#endif