#include "mbed.h"
/* Serial Dimmer  20150506 ImageWriter
/ This program is test of LPC1114 serial communication.
/ When you use Mac, it is as follows.
/   1)Run the Terminal.app.
/   2)ls /dev/tty.usb*
/       When you use USB-Serial converter and RS232C level conveter,
/           It is displayed with /dev/tty.usbserial-xxxxxxxxx.
/       When you use LPC1114FN28 mbed board from USB cable,
/           It is displayed with /dev/tty.usbmodemfdxxxx.
/   3)Run the screen command.
/       screen /dev/tty.usbXXXXXXXX.
/   4)Press 'u' to turn LED1 brightness up,'d' to turn it down.
*/   
 
//Serial pc(USBTX, USBRX); // tx, rx
Serial pc(dp16, dp15);             //LPC1114

//PwmOut led(LED1);
PwmOut led(dp1);                    //LPC1114's PWMout is dp1 and dp2.
 
float brightness = 0.0;
 
int main() {
    pc.printf("Press 'u' to turn LED1 brightness up, 'd' to turn it down\n");
 
    while(1) {
        char c = pc.getc();
        if((c == 'u') && (brightness < 0.5)) {
            brightness += 0.01;
            led = brightness;
        }
        if((c == 'd') && (brightness > 0.0)) {
            brightness -= 0.01;
            led = brightness;
        } 
        pc.printf("%c:%5.2f\r\n",c,brightness);
 
    }
}
