//#if !FEATURE_LWIP
//    #error [NOT_SUPPORTED] LWIP not supported for this target
//#endif

#define CHECKSUM_GEN_ICMP 1

#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"

#define HTTP_STATUS_LINE "HTTP/1.0 200 OK"
#define HTTP_HEADER_FIELDS "Content-Type: text/html; charset=utf-8"
#define HTTP_MESSAGE_BODY ""                                     \
"<html>" "\r\n"                                                  \
"<meta http-equiv=\"Refresh\" content=\"0.1\">"\
"  <body style=\"display:flex;text-align:center\">" "\r\n"       \
"    <div style=\"margin:auto\">" "\r\n"                         \
"      <h1>Hello World</h1>" "\r\n"                              \
"      <p>It works !</p>" "\r\n"                                 \
"      <a href=\"https://www.google.com/\">google</a>" "\r\n"    \
"      <a href=\"DETAILS.TXT\">text</a>" "\r\n"    \
"    </div>" "\r\n"                                              \
"    <h1 id=\"time\"></h1>" \
"    <script>"\
"    time();"\
"    function time(){" \
"        var now = new Date();"\
"        document.getElementById(\"time\").innerHTML = now.toLocaleTimeString();"\
"    }"\
"    setInterval(\'time()\',1000);"\
"    setTimeout(function () {"\
"           location.reload();"\
"    }, 10);"\
"    </script>"\
"  </body>" "\r\n"                                               \
"</html>"

#define HTTP_RESPONSE HTTP_STATUS_LINE "\r\n"   \
                      HTTP_HEADER_FIELDS "\r\n" \
                      "\r\n"                    \
                      HTTP_MESSAGE_BODY "\r\n"

DigitalOut led1(LED1);

int main()
{
    long i = 0;
    printf("Basic HTTP server example\n");
    
    EthernetInterface eth;
    eth.set_dhcp(false);
    eth.set_network("192.168.3.78","255.255.252.0","192.168.0.1");
    if(eth.connect() == 0){
        printf("The target IP address is '%s'\n", eth.get_ip_address());
    }else{
        printf("Connect error!");
        exit(-1);    
    }
    
    TCPServer srv;
    TCPSocket clt_sock;
    SocketAddress clt_addr;
      
    /* Open the server on ethernet stack */
    srv.open(&eth);
    
    /* Bind the HTTP port (TCP 80) to the server */
    srv.bind(eth.get_ip_address(), 80);
    
    /* Can handle 5 simultaneous connections */
    srv.listen(5);
    
    while (true) {
        srv.accept(&clt_sock, &clt_addr);
        printf("accept %s:%d\r\n", clt_addr.get_ip_address(), clt_addr.get_port());
        clt_sock.send(HTTP_RESPONSE, strlen(HTTP_RESPONSE));
        printf("%d\r\n",i++);
        led1 = !led1;
    }
}
