

#include "mbed.h"
#include "SDFileSystem.h"
#include "ILI9340_Driver.h"

Serial pc(USBTX, USBRX);                    // Use Serial interface
SDFileSystem sd(D11, D12, D13, D10, "sd");  // MOSI, MISO, SCK, CS
FILE *fp;                                   // File pointer declear

int main() {

    // create the display object
    // Nucleo-F411RE to M-TM022-SPI(Aitendo) connection.
    // 2015.4.12 ImageWriter
    // ------------------------------------------------
    // [Nucleo]     [M-TM022-SPI_TFT]   [M-TM022-SPI-SD]                
    // (D2)     --- Reset
    // (D4)     --- CS
    // (D7)     --- D/C
    // (D13)    --- CLK  --------------- SD_SCK
    // (D11)    --- MOSI --------------- SD_MOSI
    // (D12)    --- MISO --------------- SD_MISO
    // (D10)    ------------------------ SD_CS
    // (3V3)    --- VCC;
    // (3V3)    -R- LED; (330ohm)
    // (GND)    --- GND
    // (A1)     --- LM35DZ
    
    ILI9340_Display myTft = ILI9340_Display(D11, D12, D13, D4, D2, D7);

    // create the Analog object
    AnalogIn    myA1(A1);
    
    // initialise the display
    myTft.DispInit();
    
    // clears the screen to remove all noise data
    myTft.FillScreen(ILI9340_WHITE);

    // set up variables
    char roomTemptureString[] = "0000";     // Display charactor
    char roomTemptureString_old[] = "0000"; // For Erace old charactor
    int  roomTempture;                      // Room Tempture * 100
    long realTempture;                      // For calucrate
    int  xx = 1;                            // Line graph x axis
    
    while(true) {
        realTempture = 0;
        for(int i=0;i<1000;i++){            // For averaging.
            realTempture += myA1.read_u16()*33000/65535; // realTemp = 3300mv * 10 / 0xFFFF 
            }
        realTempture = realTempture/1000;    
        roomTempture = int(realTempture);               // Cast int
        //myTft.FillScreen(ILI9340_WHITE);
        
        myTft.DrawString("Now room tempture is",30,10,1,ILI9340_BLACK);
        myTft.IntToChars(roomTemptureString,roomTempture,4,10,9999,9999,3,ILI9340_BLACK); // offscreen write
        
        // Erace old charactor        
        myTft.DrawAscii(roomTemptureString_old[0],10, 50,3,ILI9340_WHITE);
        myTft.DrawAscii(roomTemptureString_old[1],30, 50,3,ILI9340_WHITE);
        //myTft.DrawAscii('.'                      ,50, 50,3,ILI9340_WHITE);
        myTft.DrawAscii(roomTemptureString_old[2],70, 50,3,ILI9340_WHITE);
        myTft.DrawAscii(roomTemptureString_old[3],90, 50,3,ILI9340_WHITE);
        //myTft.DrawString("deg C"                 ,110,50,3,ILI9340_WHITE);
        
        // Erase new charactor
        myTft.DrawAscii(roomTemptureString[0],10, 50,3,ILI9340_BLACK);
        myTft.DrawAscii(roomTemptureString[1],30, 50,3,ILI9340_BLACK);
        myTft.DrawAscii('.'                  ,50, 50,3,ILI9340_BLACK);
        myTft.DrawAscii(roomTemptureString[2],70, 50,3,ILI9340_BLACK);
        myTft.DrawAscii(roomTemptureString[3],90, 50,3,ILI9340_BLACK);
        myTft.DrawString("deg C"             ,110,50,3,ILI9340_BLACK);

        // xx axis counter
        if(xx > 239){
            xx=1;
            }else{
            xx++;
            }

        // Erese old plot
        myTft.DrawLine(xx,319,xx,(319 - 5000/25)                           ,ILI9340_WHITE);

        // Draw scale line
        myTft.DrawLine(0,319-1000/25,240,319-1000/25,ILI9340_BLACK);
        myTft.DrawLine(0,319-2000/25,240,319-2000/25,ILI9340_BLACK);
        myTft.DrawLine(0,319-3000/25,240,319-3000/25,ILI9340_BLACK);
        myTft.DrawLine(0,319-4000/25,240,319-4000/25,ILI9340_BLACK);
    
        // plot graph   
        myTft.DrawLine(xx,(317 - roomTempture/25),xx,(319 - roomTempture/25),ILI9340_BLACK);
        
        // cursor
        myTft.DrawLine(xx,319,xx,309,ILI9340_BLACK);
        
        // SD card logger
        fp = fopen("/sd/mylogger.txt", "a");            // File open for "a"ppend
        if (fp == NULL) {                               // Error!
            pc.printf("Unable to write the file\r\n");
        } else {
            pc.printf("%d \r\n",roomTempture);          // Append data to SD card.
            fprintf(fp, "%d \r\n",roomTempture);        // Serial monitor.
        }
        fclose(fp);                                     // Cloce file.
        pc.printf("File successfully written!\r\n");    // Serial monitor.

        
        wait(10);
        // erace cursor
        myTft.DrawLine(xx,319,xx,309,ILI9340_WHITE);

        // save old character 
        strcpy(roomTemptureString_old,roomTemptureString);
        
    }
}
