// Nucleo OnDeley Oneshot
#include "mbed.h"

// IO instance
#define F746ZG
#undef F746ZG
#ifdef F746ZG    
DigitalOut myled(PB_0);     // Green
DigitalOut myled2(PB_7);    // Blue
DigitalOut myled3(PB_14);   // Red
DigitalIn mySw(PC_13);      // User button
#define MYSWLOGIC 1
#endif

#define F411RE
//#undef F411RE
#ifdef F411RE    
DigitalOut myled(D13);     // LED
DigitalOut myled2(D12);    // 
DigitalOut myled3(D11);   // 
DigitalIn mySw(PC_13);      // User button
#define MYSWLOGIC 0
#endif

class OND{
    public:
        // Timer instance
        static Timeout delay1;
        static Timeout oneShot1;
    
        // Timer flag
        static bool swOn;          // Switch status. Set true when press. Set false when Time up and release. 
        static bool tmon;          // Timer status.  Set to the true when the OneShot timer starts. Set to the false when time up. 

        // Function prototype
        static void upDelay1(void);
        static void upOneShot1(void);
    
        OND(void);
};

// Functions
OND::OND(void){
    swOn = false;
    tmon = false;    
}
// Up time from delay timer. 
void OND::upDelay1(void){
    myled2 = 1;                                 // LED on
    oneShot1.attach_us(&upOneShot1, 50000);   // Set oneShot
    tmon = true;                                // tmon flag set.
}

// Up time from oneShot timeer.
void OND::upOneShot1(void){
    myled2 = 0;                                 // LED off
    delay1.detach();                            // Timeout::detach
    oneShot1.detach();                          // Timeout::detach
    tmon = false;                               // tmon flag reset.
}

int main(void) {
    OND ond;
    while(1) {
        myled3 = !myled3;
        if (mySw == MYSWLOGIC){                         // If sw on,
            myled = 1;                          // Monitor LED ON
            if(myled2 == 0 && ond.swOn == false){   // If timer is not started,
                ond.swOn = true;                    //  flag on
                ond.delay1.attach_us(&ond.upDelay1, 50000);    // Start delay timer.
            }            
        }else{                                  // If sw off,
            myled = 0; // LED is OFF            //  Monitor LED off
            if(ond.tmon == false){                  //  If timer is completed,
                ond.swOn = false;                   //      frag reset.
                ond.delay1.detach();                //      Cansel the on delay timer.
            }
         }
    }
}
