
#include "mbed.h"
#include "eeprom.h"
#include <ctype.h>



uint16_t n = 0;
/* Virtual address defined by the user: 0xFFFF value is prohibited */
uint16_t VirtAddVarTab[NB_OF_VAR] = {0x5555, 0x6666, 0x7777, 0x8888};
uint16_t VarDataTab[] = {0, 0, 0, 0};



int main()
{

    /* Unlock the Flash Program Erase controller */
    HAL_FLASH_Unlock();

    EE_Init();
    
    printf("EEPROM emulation test\n");

    printf("\n\rType one of the following commands and press space or enter");
    printf("\n\r READ - read all variables\n\r WRITE1 <n> - write first variable\n\r WRITE2 <n> - write second variable\n\r WRITE3 <n> - write third variable\n\r WRITE4 <n> - write 4th variable");
    printf("\n\rwhere <n> is uint16_t value (0-65535)");
    printf("\n\r");


    char command[20];
    char arg[10];
            int i;

    while(1) {
        scanf("%s", command);
    i=0;    
    while(command[i])
   {
      command[i]=toupper(command[i]);
      i++;
   }
       

        if (strcmp("READ", command)==0) {
            for (i=0; i<4; i++) {
                EE_ReadVariable(VirtAddVarTab[i], &VarDataTab[i]);
            };
            printf("\nvar1=%6u,  var2=%6u,  var3=%6u var3=%6u",VarDataTab[0],VarDataTab[1],VarDataTab[2],VarDataTab[3]);
        }
///////////////////////////////////////////////////////////////////////////////////////////////////////
        else if (strcmp("WRITE1", command)==0) {
            scanf("%s", arg);
            printf("\nok");
            n=atoi(arg);
            EE_WriteVariable(VirtAddVarTab[0], n);
        }
////////////////////////////////////////////////////////////////////////////////////
        else if (strcmp("WRITE2", command)==0) {
            scanf("%s", arg);
            printf("\nok");
            n=atoi(arg);
            EE_WriteVariable(VirtAddVarTab[1], n);
        }
////////////////////////////////////////////////////////////////////////////////////
        else if (strcmp("WRITE3", command)==0) {
            scanf("%s", arg);
            printf("\nok");
            n=atoi(arg);
            EE_WriteVariable(VirtAddVarTab[2], n);
        }
////////////////////////////////////////////////////////////////////////////////////
        else if (strcmp("WRITE4", command)==0) {
            scanf("%s", arg);
            printf("\nok");
            n=atoi(arg);
            EE_WriteVariable(VirtAddVarTab[3], n);
        }
////////////////////////////////////////////////////////////////////////////////////
        else if (strcmp("T1", command)==0) {
            // multiple write test. After test var1 = 1000
            printf("\nok");
            for (n=0;n<1001;n++){
                EE_WriteVariable(VirtAddVarTab[0], n);
                printf("*");
            }
            printf("\nComplete.\n");
        }
////////////////////////////////////////////////////////////////////////////////////
        else if (strcmp("T2", command)==0) {
            // multiple write test. After test var2 = 1001
            printf("\nok");
            for (n=0;n<1002;n++){
                EE_WriteVariable(VirtAddVarTab[1], n);
                printf("*");
            }
            printf("\nComplete.\n");
        }
////////////////////////////////////////////////////////////////////////////////////
        else if (strcmp("T3", command)==0) {
            // multiple write test. After test var3 = 1002
            printf("\nok");
            for (n=0;n<1003;n++){
                EE_WriteVariable(VirtAddVarTab[2], n);
                printf("*");
            }
            printf("\nComplete.");
        }
////////////////////////////////////////////////////////////////////////////////////
        else if (strcmp("T4", command)==0) {
            // multiple write test. After test var3 = 1002
            printf("\nok");
            for (n=0;n<1004;n++){
                EE_WriteVariable(VirtAddVarTab[3], n);
                printf("*");
            }
            printf("\nComplete.");
        }
////////////////////////////////////////////////////////////////////////////////////

        else perror("\nThere is no command matching. Try again");

        command[0] = arg[0] = 0;
        printf("\n\r");
    }


}
