#include "mbed.h"
#include "BiQuad.h"
#include "HIDScope.h"
#include "MODSERIAL.h"

MODSERIAL pc(USBTX, USBRX);
DigitalOut ledje(LED_GREEN);

//High Pass Filter 1
const double hf1_b0=0.9033;
const double hf1_b1=-0.9023;
const double hf1_b2=0;
const double hf1_a1=-0.9391;
const double hf1_a2=0;

//High Pass Filter 2
const double hf2_b0=1;
const double hf2_b1=-2.0018;
const double hf2_b2=1.0018;
const double hf2_a1=-1.8996;
const double hf2_a2=0.9033;

//High Pass Filter 3
const double hf3_b0=1;
const double hf3_b1=-1.9993;
const double hf3_b2=0.9993;
const double hf3_a1=-1.9581;
const double hf3_a2=0.9619;

Ticker emgSampleTicker;
AnalogIn emg(A0);

//void emgSample() {
//double emgFiltered = bqc_hf.step(emg.read());
//}

int main(){
    emgSampleTicker.attach(&emgSample, 0.01);

double biquad_hf1(double u, double&v1, double&v2, const double hf1_a1, const double hf1_a2, const double hf1_b0, const double hf1_b1, const double hf1_b2);
{
    double v = u - hf1_a1∗v1 - hf1_a2∗v2;
    hf1_y = hf1_b0∗v + hf1_b1∗v1 + hf1_b2∗v2;
    v2 = v1;
    v1 = v;
    return hf1_y
}

double biquad_hf2(double u, double&v1, double&v2, const double hf2_a1, const double hf2_a2, const double hf2_b0, const double hf2_b1, const double hf2_b2){
    u = hf1_y;
    double v = u − hf2_a1∗v1 − hf2_a2∗v2;
    hf2_y = hf2_b0∗v + hf2_b1∗v1 + hf2_b2∗v2;
    v2 = v1;
    v1 = v;
    return hf2_y
}

double biquad_hf3(double u, double&v1, double&v2, const double hf3_a1, const double hf3_a2, const double hf3_b0, const double hf3_b1, const double hf3_b2){
    u = hf2_y;
    double v = u − hf3_a1∗v1 − hf3_a2∗v2;
    hf3_y = hf3_b0∗v + hf3_b1∗v1 + hf3_b2∗v2;
    v2 = v1;
    v1 = v;
    return hf3_y
}

double printf(hf3_y);
}