#include "mbed.h"

DigitalOut led(LED1);

class Watchdog {
public:
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4 
        LPC_WDT->WDTC = s * (float)clk;         
        LPC_WDT->WDMOD = (LPC_WDT->WDMOD|0x3);                   // Enabled and Reset, without clear WD time-out flag.        
        kick();
    }
    
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
    
    /* You only can do IsWatchdogReset once... because flag must be cleared. */
    bool IsWatchdogReset() {
    	if (LPC_WDT->WDMOD & 0x4) {
		    LPC_WDT->WDMOD=(LPC_WDT->WDMOD&(~0x4)); /* Clear timeout flag. */
		    return true;
    	}
	    else return false;
    }
};

Watchdog w;

int main() {
    /* First activate WD */
    w.kick(2.5);
    
    printf("Hello World!\n");
    
    if (w.IsWatchdogReset()) 
		printf("MAIN: WD RESET Power up!!\r\n");

    int hang = 0;
    while(1) {
        printf("loop...\n");
        wait(0.1);
        
        if(hang == 10) {
            while(1);
        }

        w.kick();
        hang++;
    }
}
