#include "mbed.h"

// Address untuk masing-masing data dari IMU ADIS16407
#define SUPPLY_ADD 0x0200
#define XGYRO_ADD 0x0400
#define YGYRO_ADD 0x0600
#define ZGYRO_ADD 0x0800
#define XACCL_ADD 0x0A00
#define YACCL_ADD 0x0C00
#define ZACCL_ADD 0x0E00
#define XMAGN_ADD 0x1000
#define YMAGN_ADD 0x1200
#define ZMAGN_ADD 0x1400
#define BAROH_ADD 0x1600
#define BAROL_ADD 0x1800
#define TEMP_ADD 0x1A00
#define AUX_ADD 0x1C00
// Address untuk burst mode
#define BURST_ADD 0x4200

// Nilai sensor per LSB/resolusi
#define GYRO_LSB 0.05f
#define ACCL_LSB 0.003333f
#define MAGN_LSB 0.0005f
#define SUPPLY_LSB 0.002418f
#define TEMP_LSB 0.136f

 
SPI spi(PTD2, PTD3, PTD1); // MOSI, MISO, SCLK
DigitalOut cs(PTD0); // Chip select
Serial pc(USBTX, USBRX); // Konfigurasi UART untuk termnial

// Deklarasi Fungsi dan Prosedur
void Akuisisi_RAW_Data_IMU_Normal(void);
float konversi_data1(unsigned short accl, float resolusi);
float konversi_data2(unsigned short suhu, float resolusi);

// Variabel Global
unsigned short data_high, data_low, info[14];
float suhu, dummy, supply, xgyro, ygyro, zgyro, xaccl, yaccl, zaccl, xmagn, ymagn, zmagn;
int size;
 
int main() {
    
    // Konfigurasi baud rate terminal
    pc.baud(9600);
    
    // Variabel Lokal
    
    // Inisialisasi CS, off
    cs = 1;
    
    // Set format komunikasi SPI, 8 bit, mode 3 (CPOL = 1, CPHA = 1)
    spi.format(8,3);
    
    // Set frekuensi komunikasi SPI, 1 MHz
    spi.frequency(1000000);
 
    while(true) {        
    
        Akuisisi_RAW_Data_IMU_Normal();
        //    dummy=info[0];    
        //  Data power supply sensor dalam floating point
        supply = (info[1]&0xfff)*SUPPLY_LSB;
    
        //  Data gyroscope dalam floating point
        xgyro = konversi_data1(info[2],GYRO_LSB);
        ygyro = konversi_data1(info[3],GYRO_LSB);
        zgyro = konversi_data1(info[4],GYRO_LSB);
    
        //  Data accelerometer dalam floating point
        xaccl = konversi_data1(info[5],ACCL_LSB);
        yaccl = konversi_data1(info[6],ACCL_LSB);
        zaccl = konversi_data1(info[7],ACCL_LSB);
    
        //  Data magnetometer dalam floating point
        xmagn = konversi_data1(info[8],MAGN_LSB);
        ymagn = konversi_data1(info[9],MAGN_LSB);
        zmagn = konversi_data1(info[10],MAGN_LSB);
    
        //  Data barometer dalam floating point
    
    
        //  Data suhu internal sensor dalam floating point
        suhu = konversi_data2(info[13],TEMP_LSB);
        
        
//        pc.printf("test = 0x%x\n\r", test); // Print to PC/Serial
        pc.printf("Supply = %.6f\n\r", supply); // Print to PC/Serial
        pc.printf("xgyro = %.6f ", xgyro); // Print to PC/Serial
        pc.printf("ygyro = %.6f ", ygyro); // Print to PC/Serial
        pc.printf("zgyro = %.6f\n\r", zgyro); // Print to PC/Serial
        pc.printf("xaccl = %.6f ", xaccl); // Print to PC/Serial
        pc.printf("yaccl = %.6f ", yaccl); // Print to PC/Serial
        pc.printf("zaccl = %.6f\n\r", zaccl); // Print to PC/Serial
        pc.printf("xmagn = %.6f ", xmagn); // Print to PC/Serial
        pc.printf("ymagn = %.6f ", ymagn); // Print to PC/Serial
        pc.printf("zmagn = %.6f\n\r", zmagn); // Print to PC/Serial
        pc.printf("suhu = %.6f\n\r", suhu); // Print to PC/Serial
//        pc.printf("size zmagn = %d\n\r", size); // Print to PC/Serial
        wait(0.5f);
    }
}

void Akuisisi_RAW_Data_IMU_Normal()
{
    int count=0;
    unsigned short int dir, data; 
    for (dir=0x02;dir<0x1D;dir+=0x02)
    {
        cs = 0; // Chip Select di set 0 untuk memulai komunikasi
        data_high=spi.write(dir);
        data_low=spi.write(0x00);
        cs = 1; // Chip Select di set 1 untuk menghentikan komunikasi
        data = data_high<<8 | data_low;
        wait_us(10);
        info[count]=(data&0x3fff);
        count++;
    }
}

float konversi_data1(unsigned short accl, float resolusi)
{
    unsigned short temp1;
    float temp2;
    signed short sign;
    temp1 = accl;
    if ((temp1&0x2000) == 0) sign = 1;  
        else
        {
        temp1 = (~temp1)+1;
        temp1 = temp1&0x1fff;
        sign = -1;
        }
    temp2 = (temp1*resolusi*sign);
    return (temp2);
}

float konversi_data2(unsigned short suhu, float resolusi)
{
    unsigned short temp1;
    float temp2;
    signed short sign;
    temp1 = suhu;
    if ((temp1&0x0800) == 0) sign = 1;  
        else
        {
        temp1 = (~temp1)+1;
        temp1 = temp1&0x7ff;
        sign = -1;
        }
    temp2 = 25+(temp1*resolusi*sign);
    return (temp2);
}